/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.moxiedoc;

import com.moxiecode.moxiedoc.util.XPathHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntelliSenseGenerator {
    private Document doc;

    public IntelliSenseGenerator(Document doc) {
        this.doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateToMsFormat(File out_file, String event_class) throws IOException, XPathExpressionException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(out_file.getAbsolutePath()));
        try {
            String namespace;
            Vector<String> namespaces = new Vector<String>();
            writer.write("// Namespaces\n");
            for (Element namespaceElm : XPathHelper.findElements("//namespace", this.doc)) {
                namespace = namespaceElm.getAttribute("fullname");
                writer.write(namespace + " = {}\n");
                namespaces.add(namespace);
            }
            writer.write("\n// Classes\n");
            for (Element classElm : XPathHelper.findElements("//class", this.doc)) {
                if (namespaces.contains(classElm.getAttribute("name"))) continue;
                writer.write(classElm.getAttribute("fullname") + " = function(");
                Element constructorElm = XPathHelper.findElement("members/method[@constructor]", classElm);
                if (constructorElm != null) {
                    boolean first = true;
                    for (Element paramElm : XPathHelper.findElements("param", constructorElm)) {
                        if (!first) {
                            writer.write(", ");
                        }
                        writer.write(paramElm.getAttribute("name").replaceAll("[.]", ""));
                        first = false;
                    }
                }
                writer.write(") {\n");
                writer.write("\t/// <summary>" + classElm.getAttribute("summary") + "</summary>\n");
                if (constructorElm != null) {
                    for (Element paramElm : XPathHelper.findElements("param", constructorElm)) {
                        this.writeParam(paramElm, writer);
                    }
                }
                for (Element propertyElm : XPathHelper.findElements("members/property", classElm)) {
                    writer.write("\t/// <field name=\"" + propertyElm.getAttribute("name") + "\" type=\"" + propertyElm.getAttribute("type") + "\">" + this.trim(propertyElm.getTextContent()) + "</field>\n");
                }
                if (event_class != null) {
                    for (Element eventElm : XPathHelper.findElements("members/event", classElm)) {
                        writer.write("\t/// <field name=\"" + eventElm.getAttribute("name") + "\" type=\"" + event_class + "\">" + this.trim(eventElm.getTextContent()) + "</field>\n");
                    }
                }
                writer.write("}\n\n");
                for (Element methodElm : XPathHelper.findElements("members/method", classElm)) {
                    this.writeMethod(classElm.getAttribute("fullname"), methodElm, writer);
                }
            }
            writer.write("// Namespaces\n");
            for (Element namespaceElm : XPathHelper.findElements("//namespace", this.doc)) {
                namespace = namespaceElm.getAttribute("fullname");
                for (Element propertyElm : XPathHelper.findElements("members/property|//class[@fullname='" + namespace + "']/members/property", namespaceElm)) {
                    writer.write(namespace + "." + propertyElm.getAttribute("name") + " = new " + propertyElm.getAttribute("type") + "();\n");
                }
                for (Element eventElm : XPathHelper.findElements("members/event|//class[@fullname='" + namespace + "']/members/event", namespaceElm)) {
                    writer.write(namespace + "." + eventElm.getAttribute("name") + " = new tinymce.util.Dispatcher();\n");
                }
                for (Element methodElm : XPathHelper.findElements("members/method|//class[@fullname='" + namespace + "']/members/method", namespaceElm)) {
                    this.writeMethod(namespace, methodElm, writer);
                }
            }
            for (Element propertyElm : XPathHelper.findElements("model/members/property", this.doc)) {
                Element classElm = XPathHelper.findElement("//class[@fullname='" + propertyElm.getAttribute("type") + "']", this.doc);
                if (classElm == null) continue;
                if (classElm.hasAttribute("static")) {
                    writer.write(propertyElm.getAttribute("name") + " = " + propertyElm.getAttribute("type") + ";\n");
                    continue;
                }
                writer.write(propertyElm.getAttribute("name") + " = new " + propertyElm.getAttribute("type") + "();\n");
            }
            if (event_class != null) {
                for (Element eventElm : XPathHelper.findElements("model/members/event", this.doc)) {
                    writer.write(eventElm.getAttribute("name") + " = new " + event_class + "();\n");
                }
            }
            for (Element methodElm : XPathHelper.findElements("model/members/method", this.doc)) {
                this.writeMethod(null, methodElm, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeMethod(String prefix, Element method_elm, BufferedWriter writer) throws IOException, XPathExpressionException {
        if (method_elm != null && !method_elm.hasAttribute("constructor")) {
            if (prefix != null) {
                if (!method_elm.hasAttribute("static")) {
                    writer.write(prefix + ".prototype." + method_elm.getAttribute("name") + " = function(");
                } else {
                    writer.write(prefix + "." + method_elm.getAttribute("name") + " = function(");
                }
            } else {
                writer.write("function " + method_elm.getAttribute("name") + "(");
            }
            boolean first = true;
            for (Element paramElm : XPathHelper.findElements("param", method_elm)) {
                if (!first) {
                    writer.write(", ");
                }
                writer.write(paramElm.getAttribute("name").replaceAll("[.]", ""));
                first = false;
            }
            writer.write(") {\n");
            writer.write("\t/// <summary>" + method_elm.getAttribute("summary") + "</summary>\n");
            for (Element paramElm : XPathHelper.findElements("param", method_elm)) {
                this.writeParam(paramElm, writer);
            }
            this.writeReturn(XPathHelper.findElement("return", method_elm), writer);
            writer.write("}\n\n");
        }
    }

    private void writeParam(Element param_elm, BufferedWriter writer) throws IOException {
        if (param_elm != null) {
            writer.write("\t/// <param name=\"" + param_elm.getAttribute("name").replaceAll("[.]", "") + "\" type=\"" + param_elm.getAttribute("type") + "\"");
            if (param_elm.getAttribute("type").equals("Element")) {
                writer.write(" domElement=\"true\"");
            }
            if (param_elm.getAttribute("type").equals("Number")) {
                writer.write(" integer=\"true\"");
            }
            writer.write(">" + this.trim(param_elm.getTextContent()) + "</param>\n");
        }
    }

    private void writeReturn(Element return_elm, BufferedWriter writer) throws IOException {
        if (return_elm != null) {
            writer.write("\t/// <returns type=\"" + return_elm.getAttribute("type") + "\"");
            if (return_elm.getAttribute("type").equals("Element")) {
                writer.write(" domElement=\"true\"");
            }
            if (return_elm.getAttribute("type").equals("Number")) {
                writer.write(" integer=\"true\"");
            }
            writer.write(">" + this.trim(return_elm.getTextContent()) + "</returns>\n");
        }
    }

    private String trim(String str) {
        return str.replaceAll("[\r\n]", " ").trim();
    }
}

