/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String label;
    Image image;
    Image[] images = new Image[0];
    int dialogHandle;
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    void _setImages(Image[] images) {
        Image icon;
        if (images != null && images.length > 1) {
            Image[] bestImages = new Image[images.length];
            System.arraycopy(images, 0, bestImages, 0, images.length);
            this.sort(bestImages);
            images = bestImages;
        }
        icon = images != null && images.length > 0 ? (icon = images[0]) : null;
        int pixmap = 0;
        int mask = 0;
        if (icon != null) {
            switch (icon.type) {
                case 0: {
                    pixmap = icon.pixmap;
                    break;
                }
                case 1: {
                    pixmap = icon.pixmap;
                    mask = icon.mask;
                }
            }
        }
        int[] argList = new int[]{OS.XmNiconPixmap, pixmap, OS.XmNiconMask, mask};
        int topHandle = this.topHandle();
        OS.XtSetValues(topHandle, argList, argList.length / 2);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void bringToTop(boolean force) {
        this.moveAbove(null);
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int compare(ImageData data1, ImageData data2) {
        int transparent2;
        int transparent1 = data1.getTransparencyType();
        if (transparent1 != (transparent2 = data2.getTransparencyType())) {
            if (transparent1 == 1) {
                return 1;
            }
            if (transparent2 == 1) {
                return -1;
            }
        }
        if (data1.width == data2.width && data1.height == data2.height) {
            if (transparent1 == 2) {
                return -1;
            }
            if (transparent2 == 2) {
                return 1;
            }
            if (transparent1 == 4) {
                return -1;
            }
            if (transparent2 == 4) {
                return 1;
            }
            return 0;
        }
        return data1.width > data2.width || data1.height > data2.height ? -1 : 1;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        if (this.menuBar != null) {
            XtWidgetGeometry request = new XtWidgetGeometry();
            XtWidgetGeometry result = new XtWidgetGeometry();
            request.request_mode = 4;
            request.width = trim.width;
            OS.XtQueryGeometry(this.menuBar.handle, request, result);
            trim.height += result.height;
        }
        return trim;
    }

    void createHandle(int index) {
        this.state |= 2;
        this.createHandle(index, this.parent.handle, true);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.label = "";
    }

    int dialogHandle() {
        if (this.dialogHandle != 0) {
            return this.dialogHandle;
        }
        this.dialogHandle = OS.XmCreateDialogShell(this.handle, null, null, 0);
        return this.dialogHandle;
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.label;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmenuBar;
        int[] argList = nArray;
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        if (argList[1] != 0) {
            this.propagateHandle(enabled, argList[1], 0);
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(destroy);
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.release(false);
                }
                ++i;
            }
            this.menus = null;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.dialogHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        this.label = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean restored = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return restored;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
        this._setImages(images);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        int vHandle;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            if (!this.isEnabled() && this.menuBar.getEnabled()) {
                this.propagateHandle(true, this.menuBar.handle, 0);
            }
            this.menuBar.removeAccelerators();
        }
        if (menu != null) {
            if (!this.isEnabled()) {
                this.propagateHandle(false, menu.handle, 0);
            }
            menu.addAccelerators();
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int newHandle = menu != null ? menu.handle : 0;
        int oldHandle = this.menuBar != null ? this.menuBar.handle : 0;
        this.menuBar = menu;
        int hHandle = this.horizontalBar != null ? this.horizontalBar.handle : 0;
        int n = vHandle = this.verticalBar != null ? this.verticalBar.handle : 0;
        if (newHandle != 0) {
            OS.XtSetMappedWhenManaged(newHandle, false);
            OS.XtManageChild(newHandle);
        }
        int clientHandle = this.formHandle != 0 ? this.formHandle : this.handle;
        OS.XmMainWindowSetAreas(this.scrolledHandle, newHandle, 0, hHandle, vHandle, clientHandle);
        if (oldHandle != 0) {
            OS.XtUnmanageChild(oldHandle);
        }
        if (newHandle != 0) {
            OS.XtSetMappedWhenManaged(newHandle, true);
        }
        if (newHandle == 0 && OS.XtIsRealized(this.scrolledHandle)) {
            int[] nArray2 = new int[6];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            nArray2[4] = OS.XmNborderWidth;
            int[] argList = nArray2;
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, argList[1] + 1, argList[3], argList[5]);
            OS.XtResizeWidget(this.scrolledHandle, argList[1], argList[3], argList[5]);
        }
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNwidth;
        nArray3[2] = OS.XmNheight;
        int[] argList2 = nArray3;
        OS.XtGetValues(this.handle, argList2, argList2.length / 2);
        if (argList1[1] != argList2[1] || argList1[3] != argList2[3]) {
            this.sendEvent(11);
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.label = string;
    }

    void sort(Image[] images) {
        int length = images.length;
        if (length <= 1) {
            return;
        }
        ImageData[] datas = new ImageData[length];
        int i = 0;
        while (i < length) {
            datas[i] = images[i].getImageData();
            ++i;
        }
        int gap = length / 2;
        while (gap > 0) {
            int i2 = gap;
            while (i2 < length) {
                int j = i2 - gap;
                while (j >= 0) {
                    if (this.compare(datas[j], datas[j + gap]) >= 0) {
                        Image swap = images[j];
                        images[j] = images[j + gap];
                        images[j + gap] = swap;
                        ImageData swapData = datas[j];
                        datas[j] = datas[j + gap];
                        datas[j + gap] = swapData;
                    }
                    j -= gap;
                }
                ++i2;
            }
            gap /= 2;
        }
    }

    boolean translateAccelerator(char key, int keysym, XKeyEvent xEvent, boolean doit) {
        if (this.menuBar == null || !this.menuBar.getEnabled()) {
            return false;
        }
        int accelerator = Display.translateKey(keysym);
        if (accelerator == 0) {
            accelerator = key;
        }
        if (accelerator == 0) {
            return false;
        }
        if ((xEvent.state & 8) != 0) {
            accelerator |= 0x10000;
        }
        if ((xEvent.state & 1) != 0) {
            accelerator |= 0x20000;
        }
        if ((xEvent.state & 4) != 0) {
            accelerator |= 0x40000;
        }
        return this.menuBar.translateAccelerator(accelerator, doit);
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

