/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int labelHandle;
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNshadowThickness;
            nArray[2] = OS.XmNmarginWidth;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int thickness = argList[1];
            int marginWidth = argList[3];
            int borderWidth = this.getBorderWidth();
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNchildHorizontalSpacing;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.labelHandle, argList2, argList2.length / 2);
            XtWidgetGeometry result = new XtWidgetGeometry();
            OS.XtQueryGeometry(this.labelHandle, null, result);
            int titleWidth = result.width + 2 * (argList2[1] + marginWidth + thickness + borderWidth);
            size.x = Math.max(size.x, titleWidth);
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNshadowThickness;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNmarginHeight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int thickness = argList[1];
        int marginWidth = argList[3];
        int marginHeight = argList[5];
        int borderWidth = this.getBorderWidth();
        int trimX = x - marginWidth + thickness - borderWidth;
        int trimY = y - marginHeight + thickness - borderWidth;
        int trimWidth = width + (marginWidth + thickness + borderWidth) * 2;
        int trimHeight = height + (marginHeight + thickness + borderWidth) * 2;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray2 = new int[6];
            nArray2[0] = OS.XmNy;
            nArray2[2] = OS.XmNheight;
            nArray2[4] = OS.XmNchildHorizontalSpacing;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.labelHandle, argList2, argList2.length / 2);
            int titleHeight = (short)argList2[1] + argList2[3];
            trimY = y - titleHeight;
            trimHeight = height + titleHeight + (marginHeight + thickness + borderWidth);
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createHandle(int index) {
        this.state |= 0x80;
        int border = (this.style & 0x800) != 0 ? 1 : 0;
        int[] argList1 = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, border};
        int parentHandle = this.parent.handle;
        this.formHandle = OS.XmCreateForm(parentHandle, null, argList1, argList1.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int[] nArray = new int[12];
        nArray[0] = OS.XmNshadowType;
        nArray[1] = this.shadowType();
        nArray[2] = OS.XmNtopAttachment;
        nArray[3] = 1;
        nArray[4] = OS.XmNbottomAttachment;
        nArray[5] = 1;
        nArray[6] = OS.XmNleftAttachment;
        nArray[7] = 1;
        nArray[8] = OS.XmNrightAttachment;
        nArray[9] = 1;
        nArray[10] = OS.XmNresizable;
        int[] argList2 = nArray;
        this.handle = OS.XmCreateFrame(this.formHandle, null, argList2, argList2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] argList3 = new int[]{OS.XmNframeChildType, 2};
        this.labelHandle = OS.XmCreateLabel(this.handle, null, argList3, argList3.length / 2);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNforeground;
        nArray2[2] = OS.XmNbackground;
        int[] argList4 = nArray2;
        OS.XtGetValues(this.handle, argList4, argList4.length / 2);
        OS.XtSetValues(this.labelHandle, argList4, argList4.length / 2);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.labelHandle);
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.enableHandle(enabled, this.labelHandle);
    }

    int fontHandle() {
        return this.labelHandle;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        int[] nArray = new int[10];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNshadowThickness;
        nArray[6] = OS.XmNmarginWidth;
        nArray[8] = OS.XmNmarginHeight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int thickness = argList[5];
        int marginWidth = argList[7];
        int marginHeight = argList[9];
        int x = marginWidth + thickness;
        int y = marginHeight + thickness;
        int width = argList[1] - (marginWidth + thickness) * 2 - 1;
        int height = argList[3] - (marginHeight + thickness) * 2 - 1;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNy;
            nArray2[2] = OS.XmNheight;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.labelHandle, argList2, argList2.length / 2);
            y = (short)argList2[1] + argList2[3];
            height = argList[3] - y - (marginHeight + thickness) - 1;
        }
        return new Rectangle(x, y, width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtAddEventHandler(this.labelHandle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(this.labelHandle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(this.labelHandle, 64, false, windowProc, 26);
    }

    boolean mnemonicHit(char key) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        this.propagateHandle(enabled, this.labelHandle, 0);
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        super.redrawWidget(x, y, width, height, redrawAll, allChildren, trim);
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)x, (short)y, root_x, root_y);
        short[] label_x = new short[1];
        short[] label_y = new short[1];
        OS.XtTranslateCoords(this.labelHandle, (short)0, (short)0, label_x, label_y);
        this.redrawHandle(root_x[0] - label_x[0], root_y[0] - label_y[0], width, height, redrawAll, this.labelHandle);
    }

    void register() {
        super.register();
        this.display.addWidget(this.labelHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNforeground;
        int[] argList = nArray;
        OS.XtGetValues(this.labelHandle, argList, argList.length / 2);
        OS.XmChangeColor(this.labelHandle, pixel);
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
    }

    void setForegroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
        super.setForegroundPixel(pixel);
    }

    void setParentBackground() {
        super.setParentBackground();
        if (this.labelHandle != 0) {
            this.setParentBackground(this.labelHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        int mnemonic = Group.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), text, true);
        int xmString = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (xmString == 0) {
            this.error(13);
        }
        if (mnemonic == 0) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString, OS.XmNmnemonic, mnemonic};
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
        if (xmString != 0) {
            OS.XmStringFree(xmString);
        }
        if (string.length() == 0) {
            OS.XtUnmanageChild(this.labelHandle);
        } else {
            OS.XtManageChild(this.labelHandle);
        }
    }

    int shadowType() {
        if ((this.style & 4) != 0) {
            return 7;
        }
        if ((this.style & 8) != 0) {
            return 8;
        }
        if ((this.style & 0x10) != 0) {
            return 5;
        }
        if ((this.style & 0x40) != 0) {
            return 6;
        }
        return 5;
    }
}

