/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    TreeItem[] items = Tree.NO_ITEMS;
    int availableIndex = -1;
    int depth = 0;
    boolean checked;
    boolean grayed;
    boolean expanded;
    boolean cached;
    String[] texts;
    int[] textWidths = new int[1];
    int customWidth = -1;
    int fontHeight;
    int[] fontHeights;
    Image[] images;
    Color foreground;
    Color background;
    String[] displayTexts;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font font;
    Font[] cellFonts;
    static final int INDENT_HIERARCHY = 6;
    static final int MARGIN_TEXT = 3;

    public TreeItem(Tree parent, int style) {
        this(parent, style, TreeItem.checkNull((Tree)parent).items.length);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, style, index, true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(parentItem, style, TreeItem.checkNull((TreeItem)parentItem).items.length);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(parentItem, style, index, true);
    }

    TreeItem(TreeItem parentItem, int style, int index, boolean notifyParent) {
        super(parentItem, style);
        int columnCount;
        this.parentItem = parentItem;
        this.parent = parentItem.parent;
        this.depth = parentItem.depth + 1;
        int validItemIndex = parentItem.items.length;
        if (index < 0 || index > validItemIndex) {
            this.error(6);
        }
        if ((columnCount = this.parent.columns.length) > 0) {
            this.displayTexts = new String[columnCount];
            if (columnCount > 1) {
                this.texts = new String[columnCount];
                this.textWidths = new int[columnCount];
                this.images = new Image[columnCount];
            }
        }
        if (notifyParent) {
            parentItem.addItem(this, index);
        }
    }

    TreeItem(Tree parent, int style, int index, boolean notifyParent) {
        super(parent, style);
        int validItemIndex = parent.items.length;
        if (index < 0 || index > validItemIndex) {
            this.error(6);
        }
        this.parent = parent;
        int columnCount = parent.columns.length;
        if (columnCount > 0) {
            this.displayTexts = new String[columnCount];
            if (columnCount > 1) {
                this.texts = new String[columnCount];
                this.textWidths = new int[columnCount];
                this.images = new Image[columnCount];
            }
        }
        if (notifyParent) {
            parent.createItem(this, index);
        }
    }

    void addColumn(TreeColumn column) {
        int orderedIndex;
        int index = column.getIndex();
        int columnCount = this.parent.columns.length;
        if (columnCount > 1) {
            if (columnCount == 2) {
                this.texts = new String[2];
            } else {
                String[] newTexts = new String[columnCount];
                System.arraycopy(this.texts, 0, newTexts, 0, index);
                System.arraycopy(this.texts, index, newTexts, index + 1, columnCount - index - 1);
                this.texts = newTexts;
            }
            if (index == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (columnCount == 2) {
                this.images = new Image[2];
            } else {
                Image[] newImages = new Image[columnCount];
                System.arraycopy(this.images, 0, newImages, 0, index);
                System.arraycopy(this.images, index, newImages, index + 1, columnCount - index - 1);
                this.images = newImages;
            }
            if (index == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
            int[] newTextWidths = new int[columnCount];
            System.arraycopy(this.textWidths, 0, newTextWidths, 0, index);
            System.arraycopy(this.textWidths, index, newTextWidths, index + 1, columnCount - index - 1);
            this.textWidths = newTextWidths;
        } else {
            this.customWidth = -1;
        }
        String[] newDisplayTexts = new String[columnCount];
        if (columnCount > 1) {
            System.arraycopy(this.displayTexts, 0, newDisplayTexts, 0, index);
            System.arraycopy(this.displayTexts, index, newDisplayTexts, index + 1, columnCount - index - 1);
        }
        this.displayTexts = newDisplayTexts;
        if (this.cellBackgrounds != null) {
            Color[] newCellBackgrounds = new Color[columnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, index);
            System.arraycopy(this.cellBackgrounds, index, newCellBackgrounds, index + 1, columnCount - index - 1);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellForegrounds != null) {
            Color[] newCellForegrounds = new Color[columnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, index);
            System.arraycopy(this.cellForegrounds, index, newCellForegrounds, index + 1, columnCount - index - 1);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellFonts != null) {
            Font[] newCellFonts = new Font[columnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, index);
            System.arraycopy(this.cellFonts, index, newCellFonts, index + 1, columnCount - index - 1);
            this.cellFonts = newCellFonts;
            int[] newFontHeights = new int[columnCount];
            System.arraycopy(this.fontHeights, 0, newFontHeights, 0, index);
            System.arraycopy(this.fontHeights, index, newFontHeights, index + 1, columnCount - index - 1);
            this.fontHeights = newFontHeights;
        }
        if ((orderedIndex = column.getOrderIndex()) == 0 && columnCount > 1) {
            TreeColumn[] orderedColumns = this.parent.getOrderedColumns();
            int secondColumnIndex = orderedColumns[1].getIndex();
            GC gc = new GC(this.parent);
            gc.setFont(this.getFont(secondColumnIndex, false));
            this.computeDisplayText(secondColumnIndex, gc);
            gc.dispose();
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].addColumn(column);
            ++i;
        }
    }

    void addItem(TreeItem item, int index) {
        TreeItem[] newChildren = new TreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newChildren, 0, index);
        newChildren[index] = item;
        System.arraycopy(this.items, index, newChildren, index + 1, this.items.length - index);
        this.items = newChildren;
        if (!item.isAvailable()) {
            if (this.isInViewport() && this.items.length == 1) {
                Rectangle bounds = this.getExpanderBounds();
                this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            return;
        }
        this.parent.makeAvailable(item);
        Rectangle bounds = item.getBounds(false);
        int rightX = bounds.x + bounds.width;
        this.parent.updateHorizontalBar(rightX, rightX);
        this.parent.updateVerticalBar();
        if (item.availableIndex < this.parent.topIndex) {
            ++this.parent.topIndex;
            ScrollBar vBar = this.parent.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(this.parent.topIndex);
            }
            return;
        }
        this.parent.redrawFromItemDownwards(this.availableIndex);
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.grayed = false;
        this.checked = false;
        this.texts = null;
        this.textWidths = new int[1];
        this.fontHeight = 0;
        this.fontHeights = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.displayTexts = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.cached = false;
        this.text = "";
        this.image = null;
        int columnCount = this.parent.columns.length;
        if (columnCount > 0) {
            this.displayTexts = new String[columnCount];
            if (columnCount > 1) {
                this.texts = new String[columnCount];
                this.textWidths = new int[columnCount];
                this.images = new Image[columnCount];
            }
        }
    }

    public void clear(int index, boolean recursive) {
        Rectangle bounds;
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        TreeItem item = this.items[index];
        TreeItem[] availableDescendents = null;
        int oldRightX = 0;
        if (item.availableIndex != -1 && this.parent.columns.length == 0) {
            if (recursive) {
                availableDescendents = item.computeAvailableDescendents();
                int i = 0;
                while (i < availableDescendents.length) {
                    bounds = availableDescendents[i].getBounds(false);
                    oldRightX = Math.max(oldRightX, bounds.x + bounds.width);
                    ++i;
                }
            } else {
                Rectangle bounds2 = item.getBounds(false);
                oldRightX = bounds2.x + bounds2.width;
            }
        }
        item.clear();
        if (recursive) {
            item.clearAll(true, false);
        }
        if (item.availableIndex == -1) {
            return;
        }
        if (this.parent.columns.length == 0) {
            int newRightX = 0;
            if (recursive) {
                int i = 0;
                while (i < availableDescendents.length) {
                    Rectangle bounds3 = availableDescendents[i].getBounds(false);
                    newRightX = Math.max(newRightX, bounds3.x + bounds3.width);
                    ++i;
                }
            } else {
                bounds = item.getBounds(false);
                newRightX = bounds.x + bounds.width;
            }
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
        if (recursive) {
            int descendentCount = availableDescendents == null ? item.computeAvailableDescendentCount() : availableDescendents.length;
            this.parent.redrawItems(item.availableIndex, item.availableIndex + descendentCount - 1, false);
        } else {
            this.parent.redrawItem(item.availableIndex, false);
        }
    }

    public void clearAll(boolean recursive) {
        this.clearAll(recursive, true);
    }

    void clearAll(boolean recursive, boolean doVisualUpdate) {
        Rectangle bounds;
        int i;
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        TreeItem[] availableDescendents = null;
        int oldRightX = 0;
        if (doVisualUpdate && this.availableIndex != -1 && this.expanded && this.parent.columns.length == 0) {
            if (recursive) {
                availableDescendents = this.computeAvailableDescendents();
                i = 1;
                while (i < availableDescendents.length) {
                    bounds = availableDescendents[i].getBounds(false);
                    oldRightX = Math.max(oldRightX, bounds.x + bounds.width);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.items.length) {
                    bounds = this.items[i].getBounds(false);
                    oldRightX = Math.max(oldRightX, bounds.x + bounds.width);
                    ++i;
                }
            }
        }
        i = 0;
        while (i < this.items.length) {
            this.items[i].clear();
            if (recursive) {
                this.items[i].clearAll(true, false);
            }
            ++i;
        }
        if (!doVisualUpdate || this.availableIndex == -1 || !this.expanded) {
            return;
        }
        if (this.parent.columns.length == 0) {
            int newRightX = 0;
            if (recursive) {
                int i2 = 1;
                while (i2 < availableDescendents.length) {
                    Rectangle bounds2 = availableDescendents[i2].getBounds(false);
                    newRightX = Math.max(newRightX, bounds2.x + bounds2.width);
                    ++i2;
                }
            } else {
                bounds = this.items[0].getBounds(false);
                newRightX = bounds.x + bounds.width;
            }
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
        if (recursive) {
            int startIndex = this.items[0].availableIndex;
            TreeItem lastChild = this.items[this.items.length - 1];
            int endIndex = lastChild.availableIndex + lastChild.computeAvailableDescendentCount() - 1;
            this.parent.redrawItems(startIndex, endIndex, false);
        } else {
            i = 0;
            while (i < this.items.length) {
                this.parent.redrawItem(this.items[i].availableIndex, false);
                ++i;
            }
        }
    }

    TreeItem[] computeAllDescendents() {
        int childCount = this.items.length;
        TreeItem[][] childResults = new TreeItem[childCount][];
        int count = 1;
        int i = 0;
        while (i < childCount) {
            childResults[i] = this.items[i].computeAllDescendents();
            count += childResults[i].length;
            ++i;
        }
        TreeItem[] result = new TreeItem[count];
        int index = 0;
        result[index++] = this;
        int i2 = 0;
        while (i2 < childCount) {
            System.arraycopy(childResults[i2], 0, result, index, childResults[i2].length);
            index += childResults[i2].length;
            ++i2;
        }
        return result;
    }

    int computeAvailableDescendentCount() {
        int result = 1;
        if (!this.expanded) {
            return result;
        }
        int i = 0;
        while (i < this.items.length) {
            result += this.items[i].computeAvailableDescendentCount();
            ++i;
        }
        return result;
    }

    TreeItem[] computeAvailableDescendents() {
        if (!this.expanded) {
            return new TreeItem[]{this};
        }
        int childCount = this.items.length;
        TreeItem[][] childResults = new TreeItem[childCount][];
        int count = 1;
        int i = 0;
        while (i < childCount) {
            childResults[i] = this.items[i].computeAvailableDescendents();
            count += childResults[i].length;
            ++i;
        }
        TreeItem[] result = new TreeItem[count];
        int index = 0;
        result[index++] = this;
        int i2 = 0;
        while (i2 < childCount) {
            System.arraycopy(childResults[i2], 0, result, index, childResults[i2].length);
            index += childResults[i2].length;
            ++i2;
        }
        return result;
    }

    void computeDisplayText(int columnIndex, GC gc) {
        int availableWidth;
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            String text = this.getText(0, false);
            this.textWidths[columnIndex] = gc.stringExtent((String)text).x;
            return;
        }
        int orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        TreeColumn column = this.parent.columns[columnIndex];
        if (orderedIndex == 0) {
            availableWidth = column.getX() + column.width - this.getTextX(columnIndex) - 6;
        } else {
            availableWidth = column.width - 2 * this.parent.getCellPadding() - 6;
            if (this.images[columnIndex] != null) {
                availableWidth -= this.images[columnIndex].getBounds().width;
                availableWidth -= 3;
            }
        }
        String text = this.getText(columnIndex, false);
        int textWidth = gc.stringExtent((String)text).x;
        if (textWidth <= availableWidth) {
            this.displayTexts[columnIndex] = text;
            this.textWidths[columnIndex] = textWidth;
            return;
        }
        int ellipsisWidth = gc.stringExtent((String)"...").x;
        if ((availableWidth -= ellipsisWidth) <= 0) {
            this.displayTexts[columnIndex] = "...";
            this.textWidths[columnIndex] = ellipsisWidth;
            return;
        }
        int index = Math.min(availableWidth / gc.getFontMetrics().getAverageCharWidth(), text.length());
        textWidth = gc.stringExtent((String)text.substring((int)0, (int)index)).x;
        if (availableWidth == textWidth) {
            this.displayTexts[columnIndex] = String.valueOf(text.substring(0, index)) + "...";
            this.textWidths[columnIndex] = textWidth + ellipsisWidth;
            return;
        }
        if (availableWidth < textWidth) {
            do {
                if (--index < 0) {
                    this.displayTexts[columnIndex] = "...";
                    this.textWidths[columnIndex] = ellipsisWidth;
                    return;
                }
                text = text.substring(0, index);
            } while (availableWidth < (textWidth = gc.stringExtent((String)text).x));
            this.displayTexts[columnIndex] = String.valueOf(text) + "...";
            this.textWidths[columnIndex] = textWidth + ellipsisWidth;
            return;
        }
        int previousWidth = 0;
        while (textWidth < availableWidth) {
            previousWidth = textWidth;
            textWidth = gc.stringExtent((String)text.substring((int)0, (int)(++index))).x;
        }
        this.displayTexts[columnIndex] = String.valueOf(text.substring(0, index - 1)) + "...";
        this.textWidths[columnIndex] = previousWidth + ellipsisWidth;
    }

    void computeDisplayTexts(GC gc) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            return;
        }
        int i = 0;
        while (i < columnCount) {
            gc.setFont(this.getFont(i, false));
            this.computeDisplayText(i, gc);
            ++i;
        }
    }

    void computeTextWidths(GC gc) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        this.textWidths = new int[validColumnCount];
        int i = 0;
        while (i < this.textWidths.length) {
            String value = this.getDisplayText(i);
            if (value != null) {
                gc.setFont(this.getFont(i, false));
                this.textWidths[i] = gc.stringExtent((String)value).x;
            }
            ++i;
        }
    }

    public void dispose() {
        TreeItem focusItem;
        if (this.isDisposed()) {
            return;
        }
        int startIndex = -1;
        int endIndex = -1;
        Tree parent = this.parent;
        int index = this.getIndex();
        if (this.isAvailable()) {
            startIndex = this.isLastChild() && index > 0 ? (this.parentItem != null ? this.parentItem.items[index - 1].availableIndex : parent.items[index - 1].availableIndex) : this.availableIndex;
            endIndex = parent.availableItemsCount - 1;
        }
        if ((focusItem = parent.focusItem) != null && focusItem.hasAncestor(this)) {
            parent.setFocusItem(this, false);
            parent.reassignFocus();
            focusItem = parent.focusItem;
            if (focusItem != null) {
                parent.redrawItem(focusItem.availableIndex, true);
            }
        }
        if (this.parentItem != null) {
            this.parentItem.removeItem(this, index);
        }
        this.dispose(true);
        if (startIndex != -1) {
            parent.redrawItems(startIndex, endIndex, false);
        }
    }

    void dispose(boolean notifyParent) {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].dispose(notifyParent);
            ++i;
        }
        if (notifyParent) {
            this.parent.destroyItem(this);
        }
        super.dispose();
        this.foreground = null;
        this.background = null;
        this.cellForegrounds = null;
        this.cellBackgrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.images = null;
        this.displayTexts = null;
        this.texts = null;
        this.fontHeights = null;
        this.textWidths = null;
        this.parent = null;
        this.parentItem = null;
        this.items = null;
    }

    void expandAncestors() {
        if (this.parentItem != null) {
            this.parentItem.expandAncestors();
        }
        this.setExpanded(true);
        Event newEvent = new Event();
        newEvent.item = this;
        this.parent.inExpand = true;
        this.parent.sendEvent(17, newEvent);
        this.parent.inExpand = false;
        if (this.isDisposed()) {
            return;
        }
        if (this.items.length == 0) {
            this.expanded = false;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[columnIndex] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[columnIndex];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(true);
    }

    Rectangle getBounds(boolean checkData) {
        TreeColumn column;
        int right;
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] orderedColumns = this.parent.getOrderedColumns();
        int orderedCol0Index = orderedColumns.length == 0 ? 0 : orderedColumns[0].getIndex();
        int x = this.getTextX(orderedCol0Index);
        int width = this.textWidths[orderedCol0Index] + 6;
        if (orderedColumns.length > 0 && x + width > (right = (column = orderedColumns[0]).getX() + column.width)) {
            width = Math.max(0, right - x);
        }
        return new Rectangle(x, this.parent.getItemY(this), width, this.parent.itemHeight);
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] columns = this.parent.columns;
        int columnCount = columns.length;
        int validColumnCount = Math.max(1, columnCount);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (columnCount == 0) {
            return new Rectangle(this.getContentX(0), this.parent.getItemY(this), this.getContentWidth(0), this.parent.itemHeight - 1);
        }
        TreeColumn column = columns[columnIndex];
        if (column.getOrderIndex() == 0) {
            int x = this.getContentX(columnIndex);
            int offset = x - column.getX();
            int width = Math.max(0, column.width - offset - 1);
            return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
        }
        return new Rectangle(column.getX(), this.parent.getItemY(this) + 1, column.width, this.parent.itemHeight - 1);
    }

    Rectangle getCellBounds(int columnIndex) {
        int y = this.parent.getItemY(this);
        if (this.parent.columns.length == 0) {
            int width;
            if (this.customWidth != -1) {
                width = this.getContentX(0) + this.customWidth + this.parent.horizontalOffset;
            } else {
                int textPaintWidth = this.textWidths[0] + 6;
                width = this.getTextX(0) + textPaintWidth + this.parent.horizontalOffset;
            }
            return new Rectangle(-this.parent.horizontalOffset, y, width, this.parent.itemHeight);
        }
        TreeColumn column = this.parent.columns[columnIndex];
        return new Rectangle(column.getX(), y, column.width, this.parent.itemHeight);
    }

    Rectangle getCheckboxBounds() {
        if ((this.parent.getStyle() & 0x20) == 0) {
            return null;
        }
        int itemHeight = this.parent.itemHeight;
        Rectangle result = this.parent.checkboxBounds;
        Point[] hLinePoints = this.getHconnectorEndpoints();
        result.x = hLinePoints[1].x;
        result.y = this.parent.getItemY(this) + (itemHeight - result.height) / 2;
        return result;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.checked;
    }

    int getContentWidth(int columnIndex) {
        int orderedIndex;
        int width = this.textWidths[columnIndex] + 6;
        int n = orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        if (orderedIndex == 0) {
            width += this.parent.orderedCol0imageWidth;
            if (this.parent.orderedCol0imageWidth > 0) {
                width += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                width += image.getBounds().width + 3;
            }
        }
        return width;
    }

    int getContentX(int columnIndex) {
        int orderedIndex;
        int n = orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        if (orderedIndex > 0) {
            TreeColumn column = this.parent.columns[columnIndex];
            int contentX = column.getX() + this.parent.getCellPadding();
            if ((column.style & 0x4000) != 0) {
                return contentX;
            }
            int contentWidth = this.getContentWidth(columnIndex);
            if ((column.style & 0x20000) != 0) {
                int padding = this.parent.getCellPadding();
                contentX = Math.max(contentX, column.getX() + column.width - padding - contentWidth);
            } else {
                contentX = Math.max(contentX, column.getX() + (column.width - contentWidth) / 2);
            }
            return contentX;
        }
        if ((this.parent.style & 0x20) != 0) {
            Rectangle checkBounds = this.getCheckboxBounds();
            return checkBounds.x + checkBounds.width + 3;
        }
        int contentX = this.parent.getCellPadding() - this.parent.horizontalOffset;
        if (this.parentItem != null) {
            int expanderWidth = this.parent.expanderBounds.width + 6;
            contentX += expanderWidth * this.depth;
        }
        return (contentX += this.parent.expanderBounds.width) + 3 + 6;
    }

    String getDisplayText(int columnIndex) {
        if (this.parent.columns.length == 0) {
            return this.getText(0, false);
        }
        String result = this.displayTexts[columnIndex];
        return result != null ? result : "";
    }

    public boolean getExpanded() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.expanded;
    }

    Rectangle getExpanderBounds() {
        int itemHeight = this.parent.itemHeight;
        int x = this.parent.getCellPadding() - this.parent.horizontalOffset;
        int y = this.parent.getItemY(this);
        if (this.parentItem != null) {
            int expanderWidth = this.parent.expanderBounds.width + 6;
            x += expanderWidth * this.depth;
        }
        return new Rectangle(x, y + (itemHeight - this.parent.expanderBounds.height) / 2, this.parent.expanderBounds.width, this.parent.expanderBounds.height);
    }

    Rectangle getFocusBounds() {
        int width;
        TreeColumn[] columns = this.parent.columns;
        int orderedCol0index = columns.length == 0 ? 0 : this.parent.getOrderedColumns()[0].getIndex();
        int x = this.getTextX(orderedCol0index);
        if (columns.length > 0) {
            TreeColumn column;
            int rightX = columns[orderedCol0index].getX() + columns[orderedCol0index].width;
            x = Math.min(x, rightX - 1);
            if ((this.parent.style & 0x10000) != 0) {
                int[] columnOrder = this.parent.getColumnOrder();
                column = columns[columnOrder[columnOrder.length - 1]];
            } else {
                column = columns[orderedCol0index];
            }
            width = column.getX() + column.width - x - 1;
        } else {
            width = this.customWidth != -1 ? this.customWidth : this.textWidths[0] + 6;
        }
        return new Rectangle(x, this.parent.getItemY(this) + (this.parent.linesVisible ? 1 : 0), width, this.parent.itemHeight - (this.parent.linesVisible ? 1 : 0));
    }

    public Font getFont() {
        this.checkWidget();
        return this.getFont(true);
    }

    Font getFont(boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Font getFont(int columnIndex) {
        this.checkWidget();
        return this.getFont(columnIndex, true);
    }

    Font getFont(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getFont(checkData);
        }
        if (this.cellFonts == null || this.cellFonts[columnIndex] == null) {
            return this.getFont(checkData);
        }
        return this.cellFonts[columnIndex];
    }

    int getFontHeight() {
        if (this.fontHeight != 0) {
            return this.fontHeight;
        }
        return this.parent.fontHeight;
    }

    int getFontHeight(int columnIndex) {
        if (this.fontHeights == null || this.fontHeights[columnIndex] == 0) {
            return this.getFontHeight();
        }
        return this.fontHeights[columnIndex];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[columnIndex] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[columnIndex];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.grayed;
    }

    Point[] getHconnectorEndpoints() {
        int width;
        int x;
        Rectangle expanderBounds = this.getExpanderBounds();
        if (this.items.length == 0) {
            x = expanderBounds.x + Compatibility.ceil(expanderBounds.width, 2);
            width = Compatibility.floor(expanderBounds.width, 2) + 6;
        } else {
            x = expanderBounds.x + expanderBounds.width;
            width = 6;
        }
        int y = expanderBounds.y + expanderBounds.height / 2;
        return new Point[]{new Point(x, y), new Point(x + width, y)};
    }

    Rectangle getHitBounds() {
        int[] columnOrder = this.parent.getColumnOrder();
        int orderedCol0index = columnOrder.length == 0 ? 0 : this.parent.columns[columnOrder[0]].getIndex();
        int contentX = this.getContentX(orderedCol0index);
        int width = 0;
        TreeColumn[] columns = this.parent.columns;
        if (columns.length == 0) {
            width = this.getContentWidth(0);
        } else {
            TreeColumn column = (this.parent.style & 0x10000) != 0 ? columns[columnOrder[columnOrder.length - 1]] : columns[orderedCol0index];
            width = column.getX() + column.width - contentX;
        }
        return new Rectangle(contentX, this.parent.getItemY(this), width, this.parent.itemHeight);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int columnIndex) {
        this.checkWidget();
        return this.getImage(columnIndex, true);
    }

    Image getImage(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return null;
        }
        if (columnIndex == 0) {
            return super.getImage();
        }
        return this.images[columnIndex];
    }

    public Rectangle getImageBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        int padding = this.parent.getCellPadding();
        int startX = this.getContentX(columnIndex);
        int itemHeight = this.parent.itemHeight;
        int imageSpaceY = itemHeight - 2 * padding;
        int y = this.parent.getItemY(this);
        int orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        Image image = this.getImage(columnIndex, false);
        int drawWidth = 0;
        if (orderedIndex == 0) {
            drawWidth = this.parent.orderedCol0imageWidth;
        } else if (image != null) {
            drawWidth = image.getBounds().width;
        }
        return new Rectangle(startX, y + padding, drawWidth, imageSpaceY);
    }

    int getIndex() {
        TreeItem[] items = this.parentItem != null ? this.parentItem.items : this.parent.items;
        int i = 0;
        while (i < items.length) {
            if (items[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.items.length;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TreeItem[] result = new TreeItem[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    int getPreferredWidth(int columnIndex) {
        int orderedIndex;
        int width = 0;
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        width += gc.stringExtent((String)this.getText((int)columnIndex, (boolean)false)).x + 6;
        int n = orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        if (orderedIndex == 0) {
            if (this.parent.orderedCol0imageWidth > 0) {
                width += this.parent.orderedCol0imageWidth;
                width += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                width += image.getBounds().width;
                width += 3;
            }
        }
        if (this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.x = this.getContentX(columnIndex);
            event.y = this.parent.getItemY(this);
            event.width = width;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                boolean update = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding());
                if (update) {
                    this.parent.redraw();
                }
            }
            width = event.width;
        }
        gc.dispose();
        if (orderedIndex == 0) {
            return this.getContentX(columnIndex) + this.parent.horizontalOffset + width + this.parent.getCellPadding();
        }
        return width + 2 * this.parent.getCellPadding();
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int columnIndex) {
        this.checkWidget();
        return this.getText(columnIndex, true);
    }

    String getText(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return "";
        }
        if (columnIndex == 0) {
            return super.getText();
        }
        if (this.texts[columnIndex] == null) {
            return "";
        }
        return this.texts[columnIndex];
    }

    public Rectangle getTextBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] columns = this.parent.columns;
        int columnCount = columns.length;
        int validColumnCount = Math.max(1, columnCount);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (columnCount == 0) {
            int x = this.getTextX(0) + 3;
            int width = Math.max(0, this.getContentX(0) + this.getContentWidth(0) - x);
            return new Rectangle(x, this.parent.getItemY(this), width, this.parent.itemHeight - 1);
        }
        TreeColumn column = columns[columnIndex];
        if (column.getOrderIndex() == 0) {
            int x = this.getTextX(columnIndex) + 3;
            int offset = x - column.getX();
            int width = Math.max(0, column.width - offset - 1);
            return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
        }
        int x = this.getTextX(columnIndex) + 3;
        int offset = x - column.getX();
        int width = Math.max(0, column.width - offset - 3);
        return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
    }

    int getTextX(int columnIndex) {
        int orderedIndex = this.parent.columns.length == 0 ? 0 : this.parent.columns[columnIndex].getOrderIndex();
        int textX = this.getContentX(columnIndex);
        if (orderedIndex == 0) {
            textX += this.parent.orderedCol0imageWidth;
            if (this.parent.orderedCol0imageWidth > 0) {
                textX += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                textX += image.getBounds().width + 3;
            }
        }
        return textX;
    }

    boolean hasAncestor(TreeItem item) {
        if (this == item) {
            return true;
        }
        if (this.parentItem == null) {
            return false;
        }
        return this.parentItem.hasAncestor(item);
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != this) {
            return -1;
        }
        return item.getIndex();
    }

    boolean isAvailable() {
        if (this.parentItem == null) {
            return true;
        }
        if (!this.parentItem.expanded) {
            return false;
        }
        return this.parentItem.isAvailable();
    }

    boolean isInViewport() {
        if (this.availableIndex == -1) {
            return false;
        }
        int topIndex = this.parent.topIndex;
        if (this.availableIndex < topIndex) {
            return false;
        }
        int visibleCount = this.parent.clientArea.height / this.parent.itemHeight;
        return this.availableIndex <= topIndex + visibleCount;
    }

    boolean isLastChild() {
        if (this.parentItem != null) {
            return this.getIndex() == this.parentItem.items.length - 1;
        }
        return this.getIndex() == this.parent.items.length - 1;
    }

    boolean isSelected() {
        return this.parent.getSelectionIndex(this) != -1;
    }

    boolean paint(GC gc, TreeColumn column, boolean backgroundOnly) {
        int fillWidth;
        if (!this.parent.checkData(this, true)) {
            return false;
        }
        int columnIndex = 0;
        int orderedIndex = 0;
        int x = 0;
        if (column != null) {
            columnIndex = column.getIndex();
            orderedIndex = column.getOrderIndex();
            x = column.getX();
        }
        int oldAlpha = gc.getAlpha();
        boolean oldAdvanced = gc.getAdvanced();
        int oldAntialias = gc.getAntialias();
        Pattern oldBackgroundPattern = gc.getBackgroundPattern();
        Pattern oldForegroundPattern = gc.getForegroundPattern();
        int oldInterpolation = gc.getInterpolation();
        int[] oldLineDash = gc.getLineDash();
        int oldLineWidth = gc.getLineWidth();
        int oldTextAntialias = gc.getTextAntialias();
        if (this.parent.hooks(41)) {
            int contentWidth = this.getContentWidth(columnIndex);
            int contentX = this.getContentX(columnIndex);
            gc.setFont(this.getFont(columnIndex, false));
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.x = contentX;
            event.y = this.parent.getItemY(this);
            event.width = contentWidth;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setLineDash(oldLineDash);
            gc.setLineWidth(oldLineWidth);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            if (this.isDisposed()) {
                return false;
            }
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                boolean update = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding());
                if (update) {
                    this.parent.redraw();
                }
            }
            if (this.parent.columns.length == 0) {
                int change = event.width - (this.customWidth != -1 ? this.customWidth : contentWidth);
                if (event.width != contentWidth || this.customWidth != -1) {
                    this.customWidth = event.width;
                }
                if (change != 0) {
                    this.parent.updateHorizontalBar(contentX + event.width, change);
                }
            }
        }
        Rectangle clientArea = this.parent.clientArea;
        if (clientArea.x + clientArea.width < x) {
            return false;
        }
        Rectangle cellBounds = this.getCellBounds(columnIndex);
        if (this.parent.linesVisible) {
            ++cellBounds.y;
            --cellBounds.height;
        }
        int cellRightX = 0;
        cellRightX = column != null ? column.getX() + column.width : cellBounds.x + cellBounds.width;
        gc.setClipping(x, cellBounds.y, clientArea.width - x, cellBounds.height);
        int y = this.parent.getItemY(this);
        int itemHeight = this.parent.itemHeight;
        if (column == null) {
            this.parent.drawBackground(gc, 0, y, clientArea.width, itemHeight);
        } else {
            int fillWidth2 = cellBounds.width;
            if (this.parent.linesVisible) {
                --fillWidth2;
            }
            this.parent.drawBackground(gc, cellBounds.x, cellBounds.y, fillWidth2, cellBounds.height);
        }
        boolean isSelected = this.isSelected();
        boolean isFocusItem = this.parent.focusItem == this && this.parent.isFocusControl();
        boolean drawBackground = true;
        boolean drawForeground = true;
        boolean drawSelection = isSelected;
        boolean drawFocus = isFocusItem;
        if (this.parent.hooks(40)) {
            drawBackground = this.background != null || this.cellBackgrounds != null && this.cellBackgrounds[columnIndex] != null;
            gc.setFont(this.getFont(columnIndex, false));
            if (isSelected && (columnIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                gc.setForeground(this.display.getSystemColor(27));
                gc.setBackground(this.display.getSystemColor(26));
            } else {
                gc.setForeground(this.getForeground(columnIndex));
                gc.setBackground(this.getBackground(columnIndex));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.doit = true;
            event.detail = 16;
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected) {
                event.detail |= 2;
            }
            if (isFocusItem) {
                event.detail |= 4;
            }
            event.x = cellBounds.x;
            event.y = cellBounds.y;
            event.width = cellBounds.width;
            event.height = cellBounds.height;
            gc.setClipping(cellBounds);
            this.parent.sendEvent(40, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setClipping(cellBounds);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setLineDash(oldLineDash);
            gc.setLineWidth(oldLineWidth);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            if (this.isDisposed()) {
                return false;
            }
            if (!event.doit) {
                drawFocus = false;
                drawSelection = false;
                drawForeground = false;
                drawBackground = false;
            } else {
                drawBackground = drawBackground && (event.detail & 8) != 0;
                drawForeground = (event.detail & 0x10) != 0;
                drawSelection = isSelected && (event.detail & 2) != 0;
                boolean bl = drawFocus = isFocusItem && (event.detail & 4) != 0;
            }
        }
        if (drawBackground) {
            gc.setBackground(this.getBackground(columnIndex));
            if (columnIndex == 0 && (column == null || column.getOrderIndex() == 0)) {
                Rectangle focusBounds = this.getFocusBounds();
                fillWidth = 0;
                if (column == null) {
                    fillWidth = focusBounds.width;
                } else {
                    fillWidth = column.width - focusBounds.x;
                    if (this.parent.linesVisible) {
                        --fillWidth;
                    }
                }
                gc.fillRectangle(focusBounds.x, focusBounds.y, fillWidth, focusBounds.height);
            } else {
                int fillWidth3 = cellBounds.width;
                gc.fillRectangle(cellBounds.x, cellBounds.y, fillWidth3, cellBounds.height);
            }
        }
        if (drawSelection && isSelected && (orderedIndex == 0 || (this.parent.style & 0x10000) != 0)) {
            gc.setBackground(this.display.getSystemColor(26));
            if (orderedIndex == 0) {
                Rectangle focusBounds = this.getFocusBounds();
                fillWidth = focusBounds.width;
                if (this.parent.columns.length < 2 || (this.parent.style & 0x10000) == 0) {
                    fillWidth -= 2;
                }
                if (fillWidth > 0) {
                    gc.fillRectangle(focusBounds.x + 1, focusBounds.y + 1, fillWidth, focusBounds.height - 2);
                }
            } else {
                int fillWidth4 = column.width;
                int[] columnOrder = this.parent.getColumnOrder();
                if (columnIndex == columnOrder[columnOrder.length - 1]) {
                    fillWidth4 -= 2;
                }
                if (fillWidth4 > 0) {
                    gc.fillRectangle(column.getX(), cellBounds.y + 1, fillWidth4, cellBounds.height - 2);
                }
            }
        }
        if (backgroundOnly) {
            return false;
        }
        if (orderedIndex == 0) {
            gc.setClipping(cellBounds);
            Rectangle expanderBounds = this.getExpanderBounds();
            Color oldForeground = gc.getForeground();
            gc.setForeground(this.parent.getConnectorColor());
            int lineX = expanderBounds.x + expanderBounds.width / 2;
            int y2 = expanderBounds.y;
            if (this.items.length == 0) {
                y2 += expanderBounds.height / 2;
            }
            if (this.parentItem != null || this.getIndex() != 0) {
                gc.drawLine(lineX, y, lineX, y2);
            }
            if (!this.isLastChild()) {
                if (this.items.length != 0) {
                    y2 += expanderBounds.height;
                }
                gc.drawLine(lineX, y2, lineX, y + itemHeight);
            }
            Point[] endpoints = this.getHconnectorEndpoints();
            gc.drawLine(endpoints[0].x, endpoints[0].y, endpoints[1].x - 3, endpoints[1].y);
            TreeItem item = this.parentItem;
            while (item != null) {
                if (!item.isLastChild()) {
                    Rectangle itemExpanderBounds = item.getExpanderBounds();
                    lineX = itemExpanderBounds.x + itemExpanderBounds.width / 2;
                    gc.drawLine(lineX, y, lineX, y + itemHeight);
                }
                item = item.parentItem;
            }
            gc.setForeground(oldForeground);
            if (this.items.length > 0) {
                Image image = this.expanded ? this.parent.getExpandedImage() : this.parent.getCollapsedImage();
                gc.drawImage(image, expanderBounds.x, expanderBounds.y);
            }
            if ((this.parent.style & 0x20) != 0) {
                Image baseImage = this.grayed ? this.parent.getGrayUncheckedImage() : this.parent.getUncheckedImage();
                Rectangle checkboxBounds = this.getCheckboxBounds();
                gc.drawImage(baseImage, checkboxBounds.x, checkboxBounds.y);
                if (this.checked) {
                    Image checkmarkImage = this.parent.getCheckmarkImage();
                    Rectangle checkmarkBounds = checkmarkImage.getBounds();
                    int xInset = (checkboxBounds.width - checkmarkBounds.width) / 2;
                    int yInset = (checkboxBounds.height - checkmarkBounds.height) / 2;
                    gc.drawImage(checkmarkImage, checkboxBounds.x + xInset, checkboxBounds.y + yInset);
                }
            }
        }
        if (drawForeground) {
            Image image = this.getImage(columnIndex, false);
            String text = this.getDisplayText(columnIndex);
            Rectangle imageArea = this.getImageBounds(columnIndex);
            int startX = imageArea.x;
            int padding = this.parent.getCellPadding();
            gc.setClipping(startX, cellBounds.y + padding - (this.parent.linesVisible ? 1 : 0), cellRightX - startX - padding, cellBounds.height - 2 * (padding - (this.parent.linesVisible ? 1 : 0)));
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, imageArea.x, imageArea.y, imageArea.width, imageArea.height);
            }
            if (text.length() > 0) {
                gc.setFont(this.getFont(columnIndex, false));
                int fontHeight = this.getFontHeight(columnIndex);
                if (drawSelection && (orderedIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                    gc.setForeground(this.display.getSystemColor(27));
                } else if (!isSelected || drawSelection) {
                    gc.setForeground(this.getForeground(columnIndex));
                }
                x = this.getTextX(columnIndex) + 3;
                gc.drawString(text, x, y + (itemHeight - fontHeight) / 2, true);
            }
        }
        if (this.parent.hooks(42)) {
            int contentWidth = this.getContentWidth(columnIndex);
            int contentX = this.getContentX(columnIndex);
            gc.setFont(this.getFont(columnIndex, false));
            if (isSelected && (columnIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                gc.setForeground(this.display.getSystemColor(27));
                gc.setBackground(this.display.getSystemColor(26));
            } else {
                gc.setForeground(this.getForeground(columnIndex));
                gc.setBackground(this.getBackground(columnIndex));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            if (isSelected) {
                event.detail |= 2;
            }
            if (drawFocus) {
                event.detail |= 4;
            }
            event.x = contentX;
            event.y = cellBounds.y;
            event.width = contentWidth;
            event.height = cellBounds.height;
            gc.setClipping(cellBounds);
            this.parent.sendEvent(42, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setClipping(cellBounds);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setLineDash(oldLineDash);
            gc.setLineWidth(oldLineWidth);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            boolean bl = drawFocus = isFocusItem && (event.detail & 4) != 0;
        }
        return isFocusItem && !drawFocus;
    }

    void redraw(int x, int y, int width, int height, int columnIndex) {
        if (!this.parent.hooks(40) && !this.parent.hooks(42)) {
            this.parent.redraw(x, y, width, height, false);
            return;
        }
        Rectangle cellBounds = this.getCellBounds(columnIndex);
        this.parent.redraw(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, false);
    }

    void redrawItem() {
        if (!this.isAvailable()) {
            return;
        }
        this.parent.redraw(0, this.parent.getItemY(this), this.parent.clientArea.width, this.parent.itemHeight, false);
    }

    void removeColumn(TreeColumn column, int index, int orderedIndex) {
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            this.cellForegrounds = null;
            this.cellBackgrounds = null;
            this.displayTexts = null;
            this.cellFonts = null;
            this.fontHeights = null;
            GC gc = new GC(this.parent);
            this.computeTextWidths(gc);
            gc.dispose();
            int i = 0;
            while (i < this.items.length) {
                this.items[i].removeColumn(column, index, orderedIndex);
                ++i;
            }
            return;
        }
        String[] newTexts = new String[columnCount];
        System.arraycopy(this.texts, 0, newTexts, 0, index);
        System.arraycopy(this.texts, index + 1, newTexts, index, columnCount - index);
        this.texts = newTexts;
        Image[] newImages = new Image[columnCount];
        System.arraycopy(this.images, 0, newImages, 0, index);
        System.arraycopy(this.images, index + 1, newImages, index, columnCount - index);
        this.images = newImages;
        int[] newTextWidths = new int[columnCount];
        System.arraycopy(this.textWidths, 0, newTextWidths, 0, index);
        System.arraycopy(this.textWidths, index + 1, newTextWidths, index, columnCount - index);
        this.textWidths = newTextWidths;
        String[] newDisplayTexts = new String[columnCount];
        System.arraycopy(this.displayTexts, 0, newDisplayTexts, 0, index);
        System.arraycopy(this.displayTexts, index + 1, newDisplayTexts, index, columnCount - index);
        this.displayTexts = newDisplayTexts;
        if (this.cellBackgrounds != null) {
            Color[] newCellBackgrounds = new Color[columnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, index);
            System.arraycopy(this.cellBackgrounds, index + 1, newCellBackgrounds, index, columnCount - index);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellForegrounds != null) {
            Color[] newCellForegrounds = new Color[columnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, index);
            System.arraycopy(this.cellForegrounds, index + 1, newCellForegrounds, index, columnCount - index);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellFonts != null) {
            Font[] newCellFonts = new Font[columnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, index);
            System.arraycopy(this.cellFonts, index + 1, newCellFonts, index, columnCount - index);
            this.cellFonts = newCellFonts;
            int[] newFontHeights = new int[columnCount];
            System.arraycopy(this.fontHeights, 0, newFontHeights, 0, index);
            System.arraycopy(this.fontHeights, index + 1, newFontHeights, index, columnCount - index);
            this.fontHeights = newFontHeights;
        }
        if (index == 0) {
            this.text = this.texts[0] != null ? this.texts[0] : "";
            this.texts[0] = null;
            this.image = this.images[0];
            this.images[0] = null;
        }
        if (orderedIndex == 0) {
            int firstColumnIndex = this.parent.getOrderedColumns()[0].getIndex();
            GC gc = new GC(this.parent);
            gc.setFont(this.getFont(firstColumnIndex, false));
            this.computeDisplayText(firstColumnIndex, gc);
            gc.dispose();
        }
        if (columnCount < 2) {
            this.texts = null;
            this.images = null;
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].removeColumn(column, index, orderedIndex);
            ++i;
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        int lastAvailableIndex = this.parent.availableItemsCount - 1;
        TreeItem focusItem = this.parent.focusItem;
        if (focusItem != null && focusItem.hasAncestor(this)) {
            this.parent.setFocusItem(this, false);
        }
        while (this.items.length > 0) {
            this.items[0].dispose(true);
            this.removeItem(this.items[0], 0);
        }
        this.items = Tree.NO_ITEMS;
        this.expanded = false;
        if (this.isAvailable()) {
            this.parent.redrawItems(this.availableIndex, lastAvailableIndex, false);
        }
    }

    void removeItem(TreeItem item, int index) {
        if (this.isDisposed()) {
            return;
        }
        TreeItem[] newItems = new TreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, newItems.length - index);
        this.items = newItems;
        if (this.items.length == 0) {
            this.items = Tree.NO_ITEMS;
            if (!this.parent.inExpand) {
                this.expanded = false;
                if (this.isInViewport()) {
                    Rectangle bounds = this.getExpanderBounds();
                    this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
            }
            return;
        }
    }

    public void setBackground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.background) == color) {
            return;
        }
        this.background = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setBackground(int columnIndex, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellBackgrounds == null) {
            if (color == null) {
                return;
            }
            this.cellBackgrounds = new Color[validColumnCount];
        }
        if ((oldColor = this.cellBackgrounds[columnIndex]) == color) {
            return;
        }
        this.cellBackgrounds[columnIndex] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle bounds = this.getCellBounds(columnIndex);
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setChecked(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.checked == value) {
            return;
        }
        this.checked = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            if (this.parent.hooks(40) || this.parent.hooks(42)) {
                this.redrawItem();
            } else {
                Rectangle bounds = this.getCheckboxBounds();
                this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
        }
    }

    public void setExpanded(boolean value) {
        this.checkWidget();
        if (this.expanded == value) {
            return;
        }
        if (this.items.length == 0) {
            return;
        }
        if (this.parent.inExpand) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (value) {
            this.expanded = value;
            if (this.availableIndex == -1) {
                return;
            }
            TreeItem[] availableDescendents = this.computeAvailableDescendents();
            int descendentsCount = availableDescendents.length;
            if (this.availableIndex != this.parent.availableItemsCount - 1) {
                Rectangle clientArea = this.parent.clientArea;
                int y = this.parent.getItemY(this) + this.parent.itemHeight;
                if (y > 0 && y < clientArea.height && this.parent.drawCount <= 0) {
                    this.parent.update();
                    GC gc = new GC(this.parent);
                    gc.copyArea(0, y, clientArea.width, clientArea.height - y, 0, y + (descendentsCount - 1) * this.parent.itemHeight);
                    gc.dispose();
                }
            }
            this.parent.makeDescendentsAvailable(this, availableDescendents);
            int rightX = 0;
            int i = 1;
            while (i < availableDescendents.length) {
                Rectangle bounds = availableDescendents[i].getBounds(false);
                rightX = Math.max(rightX, bounds.x + bounds.width);
                ++i;
            }
            this.parent.updateHorizontalBar(rightX, rightX);
            this.parent.updateVerticalBar();
            if (this.availableIndex < this.parent.topIndex) {
                this.parent.topIndex += descendentsCount - 1;
                ScrollBar vBar = this.parent.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.parent.topIndex);
                }
                return;
            }
            int redrawStart = this.availableIndex + 1;
            int redrawEnd = redrawStart + descendentsCount - 2;
            this.parent.redrawItems(redrawStart, redrawEnd, false);
        } else {
            TreeItem[] descendents = this.computeAvailableDescendents();
            this.expanded = value;
            if (this.availableIndex == -1) {
                return;
            }
            Rectangle clientArea = this.parent.clientArea;
            int y = this.parent.getItemY(this) + this.parent.itemHeight;
            int startY = y + (descendents.length - 1) * this.parent.itemHeight;
            if (y < clientArea.height && startY > 0 && this.parent.drawCount <= 0) {
                this.parent.update();
                GC gc = new GC(this.parent);
                gc.copyArea(0, startY, clientArea.width, clientArea.height - startY, 0, y);
                gc.dispose();
                int redrawY = y + Math.max(0, clientArea.height - startY);
                this.parent.redraw(0, redrawY, clientArea.width, clientArea.height - redrawY, false);
            }
            this.parent.makeDescendentsUnavailable(this, descendents);
            int bottomIndex = this.availableIndex + descendents.length - 1;
            if (bottomIndex < this.parent.topIndex) {
                this.parent.topIndex = this.parent.topIndex - descendents.length + 1;
                ScrollBar vBar = this.parent.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.parent.topIndex);
                }
            }
            this.parent.updateHorizontalBar();
            this.parent.updateVerticalBar();
            TreeItem focusItem = this.parent.focusItem;
            if (focusItem != null && focusItem != this && focusItem.hasAncestor(this)) {
                this.parent.setFocusItem(this, false);
                if ((this.parent.style & 4) != 0) {
                    this.parent.selectItem(this, false);
                }
                Event newEvent = new Event();
                newEvent.item = this;
                this.parent.sendEvent(13, newEvent);
                if (this.isDisposed()) {
                    return;
                }
                this.parent.showItem(this);
                this.parent.redrawItem(this.availableIndex, true);
            }
        }
        if (this.isInViewport()) {
            Rectangle bounds = this.getExpanderBounds();
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(false));
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.computeDisplayTexts(gc);
        this.computeTextWidths(gc);
        gc.dispose();
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
        this.redrawItem();
    }

    public void setFont(int columnIndex, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellFonts == null) {
            if (font == null) {
                return;
            }
            this.cellFonts = new Font[validColumnCount];
        }
        if ((oldFont = this.cellFonts[columnIndex]) == font) {
            return;
        }
        this.cellFonts[columnIndex] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        if (this.fontHeights == null) {
            this.fontHeights = new int[validColumnCount];
        }
        this.fontHeights[columnIndex] = gc.getFontMetrics().getHeight();
        this.computeDisplayText(columnIndex, gc);
        gc.dispose();
        if (this.isInViewport()) {
            Rectangle bounds = this.getCellBounds(columnIndex);
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setForeground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setForeground(int columnIndex, Color value) {
        Color oldColor;
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellForegrounds == null) {
            if (value == null) {
                return;
            }
            this.cellForegrounds = new Color[validColumnCount];
        }
        if ((oldColor = this.cellForegrounds[columnIndex]) == value) {
            return;
        }
        this.cellForegrounds[columnIndex] = value;
        if (oldColor != null && oldColor.equals(value)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(columnIndex), this.parent.getItemY(this), this.textWidths[columnIndex] + 6, this.parent.itemHeight, columnIndex);
        }
    }

    public void setGrayed(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.grayed == value) {
            return;
        }
        this.grayed = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle bounds = this.getCheckboxBounds();
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setImage(Image value) {
        this.checkWidget();
        this.setImage(0, value);
    }

    public void setImage(Image[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setImage(i, value[i]);
            }
            ++i;
        }
    }

    public void setImage(int columnIndex, Image value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        TreeColumn[] columns = this.parent.columns;
        int validColumnCount = Math.max(1, columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        Image image = this.getImage(columnIndex, false);
        if (value == image) {
            return;
        }
        if (value != null && value.equals(image)) {
            return;
        }
        if (columnIndex == 0) {
            super.setImage(value);
        } else {
            this.images[columnIndex] = value;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (columns.length > 0) {
            GC gc = new GC(this.parent);
            gc.setFont(this.getFont(columnIndex, false));
            this.computeDisplayText(columnIndex, gc);
            gc.dispose();
        }
        if (value == null) {
            this.redrawItem();
            return;
        }
        if (columns.length == 0) {
            if (this.parent.imageHeight == 0) {
                Rectangle bounds = value.getBounds();
                this.parent.orderedCol0imageWidth = bounds.width;
                this.parent.setImageHeight(bounds.height);
                this.parent.redrawItems(0, this.parent.availableItemsCount - 1, false);
            } else {
                this.redrawItem();
            }
            return;
        }
        TreeColumn column = columns[columnIndex];
        int orderedIndex = column.getOrderIndex();
        Rectangle bounds = value.getBounds();
        if (column.itemImageWidth == 0) {
            column.itemImageWidth = bounds.width;
        }
        if (this.parent.imageHeight == 0) {
            int oldItemHeight = this.parent.itemHeight;
            this.parent.setImageHeight(bounds.height);
            if (orderedIndex == 0) {
                this.parent.orderedCol0imageWidth = bounds.width;
                TreeItem[] rootItems = this.parent.items;
                GC gc = new GC(this.parent);
                int i = 0;
                while (i < rootItems.length) {
                    rootItems[i].updateColumnWidth(column, gc);
                    ++i;
                }
                gc.dispose();
                if (oldItemHeight != this.parent.itemHeight) {
                    this.parent.redraw();
                } else {
                    this.parent.redraw(column.getX(), 0, column.width, this.parent.clientArea.height, false);
                }
            } else if (oldItemHeight != this.parent.itemHeight) {
                this.parent.redraw();
            } else {
                this.redrawItem();
            }
            return;
        }
        if (orderedIndex == 0 && this.parent.orderedCol0imageWidth == 0) {
            this.parent.orderedCol0imageWidth = bounds.width;
            TreeItem[] rootItems = this.parent.items;
            GC gc = new GC(this.parent);
            int i = 0;
            while (i < rootItems.length) {
                rootItems[i].updateColumnWidth(column, gc);
                ++i;
            }
            gc.dispose();
            this.parent.redraw(column.getX(), 0, column.width, this.parent.clientArea.height, false);
            return;
        }
        this.redrawItem();
    }

    public void setItemCount(int count) {
        int redrawEnd;
        int redrawStart;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.items.length) {
            return;
        }
        if (count < this.items.length) {
            redrawStart = count > 0 ? this.items[count - 1].availableIndex : this.availableIndex;
            redrawEnd = this.parent.availableItemsCount - 1;
            int i = count;
            while (i < this.items.length) {
                this.items[i].dispose(true);
                ++i;
            }
            if (count == 0) {
                this.items = Tree.NO_ITEMS;
            } else {
                TreeItem[] newItems = new TreeItem[count];
                System.arraycopy(this.items, 0, newItems, 0, count);
                this.items = newItems;
            }
            if (count == 0) {
                this.expanded = false;
            }
        } else {
            int oldAvailableDescendentCount = this.computeAvailableDescendentCount();
            int grow = count - this.items.length;
            redrawStart = this.items.length == 0 ? this.availableIndex : this.items[this.items.length - 1].availableIndex;
            redrawEnd = this.expanded && this.isAvailable() ? this.parent.availableItemsCount + grow - 1 : redrawStart;
            TreeItem[] newItems = new TreeItem[count];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            int i = this.items.length - grow;
            while (i < count) {
                this.items[i] = new TreeItem(this, 0, i, false);
                ++i;
            }
            if (this.expanded && this.availableIndex != -1) {
                if (this.parent.availableItems.length < this.parent.availableItemsCount + grow) {
                    TreeItem[] newAvailableItems = new TreeItem[this.parent.availableItemsCount + grow];
                    System.arraycopy(this.parent.availableItems, 0, newAvailableItems, 0, this.parent.availableItemsCount);
                    this.parent.availableItems = newAvailableItems;
                }
                TreeItem[] availableItems = this.parent.availableItems;
                int dest = this.availableIndex + oldAvailableDescendentCount + grow;
                System.arraycopy(availableItems, this.availableIndex + oldAvailableDescendentCount, availableItems, dest, availableItems.length - dest);
                this.parent.availableItemsCount += grow;
                System.arraycopy(this.items, this.items.length - grow, availableItems, this.availableIndex + oldAvailableDescendentCount, grow);
                int i2 = this.availableIndex + oldAvailableDescendentCount;
                while (i2 < this.parent.availableItemsCount) {
                    availableItems[i2].availableIndex = i2;
                    ++i2;
                }
            }
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.availableIndex != -1) {
            if (this.expanded) {
                this.parent.updateVerticalBar();
            }
            this.parent.redrawItems(redrawStart, redrawEnd, false);
        }
    }

    public void setText(String value) {
        this.checkWidget();
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        this.setText(0, value);
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
    }

    public void setText(String[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setText(i, value[i]);
            }
            ++i;
        }
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
    }

    public void setText(int columnIndex, String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (value.equals(this.getText(columnIndex, false))) {
            return;
        }
        if (columnIndex == 0) {
            super.setText(value);
        } else {
            this.texts[columnIndex] = value;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        int oldWidth = this.textWidths[columnIndex];
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        this.computeDisplayText(columnIndex, gc);
        gc.dispose();
        if (this.availableIndex == -1) {
            return;
        }
        if (this.parent.columns.length == 0) {
            Rectangle bounds = this.getBounds(false);
            int rightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(rightX, this.textWidths[columnIndex] - oldWidth);
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(columnIndex), this.parent.getItemY(this), Math.max(oldWidth, this.textWidths[columnIndex]) + 6, this.parent.itemHeight, columnIndex);
        }
    }

    void updateColumnWidth(TreeColumn column, GC gc) {
        int columnIndex = column.getIndex();
        gc.setFont(this.getFont(columnIndex, false));
        String oldDisplayText = this.displayTexts[columnIndex];
        this.computeDisplayText(columnIndex, gc);
        if (this.isInViewport()) {
            Rectangle cellBounds;
            boolean columnIsLeft;
            boolean bl = columnIsLeft = (column.style & 0x4000) != 0;
            if (!columnIsLeft || this.parent.hooks(40) || this.parent.hooks(42)) {
                cellBounds = this.getCellBounds(columnIndex);
                this.parent.redraw(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, false);
            } else if (oldDisplayText == null || !oldDisplayText.equals(this.displayTexts[columnIndex])) {
                cellBounds = this.getCellBounds(columnIndex);
                int textX = this.getTextX(columnIndex);
                this.parent.redraw(textX, cellBounds.y, cellBounds.x + cellBounds.width - textX, cellBounds.height, false);
            }
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].updateColumnWidth(column, gc);
            ++i;
        }
    }

    void updateFont(GC gc) {
        if (this.font == null) {
            this.computeDisplayTexts(gc);
            this.computeTextWidths(gc);
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].updateFont(gc);
            ++i;
        }
    }
}

