/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IPathEditorInput;

public class ResourceExtender
extends PropertyTester {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String PROPERTY_MATCHES_CONTENT_TYPE = "matchesContentType";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IResource resource;
        IAdaptable iAdaptable = (IAdaptable)receiver;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method)) {
                IPath path;
                File file;
                IPathEditorInput editorInput;
                IAdaptable iAdaptable2 = (IAdaptable)receiver;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IPathEditorInput");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((editorInput = (IPathEditorInput)iAdaptable2.getAdapter((Class)clazz2)) != null && (file = (path = editorInput.getPath()).toFile()).exists()) {
                    try {
                        FileReader reader = new FileReader(file);
                        IContentType contentType = Platform.getContentTypeManager().getContentType((String)expectedValue);
                        IContentDescription description = contentType.getDescriptionFor((Reader)reader, IContentDescription.ALL);
                        reader.close();
                        if (description != null) {
                            return this.matchesContentType(description.getContentType(), (String)expectedValue);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return false;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
        } else {
            if (PROPERTY_MATCHES_PATTERN.equals(method)) {
                String fileName = resource.getName();
                String expected = (String)expectedValue;
                expected = expected.replaceAll("\\.", "\\\\.");
                expected = expected.replaceAll("\\*", "\\.\\*");
                Pattern pattern = Pattern.compile(expected);
                boolean retVal = pattern.matcher(fileName).find();
                return retVal;
            }
            if (PROJECT_NATURE.equals(method)) {
                try {
                    IProject proj = resource.getProject();
                    return proj != null && proj.isAccessible() && proj.hasNature((String)expectedValue);
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method)) {
                return this.matchesContentType(resource, (String)expectedValue);
            }
        }
        return false;
    }

    private boolean matchesContentType(IContentType type, String typeId) {
        while (type != null) {
            if (typeId.equals(type.getId())) {
                return true;
            }
            type = type.getBaseType();
        }
        return false;
    }

    private boolean matchesContentType(IResource resource, String contentType) {
        IContentDescription description;
        if (resource == null || !(resource instanceof IFile) || !resource.exists()) {
            return false;
        }
        IFile file = (IFile)resource;
        try {
            description = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (description != null) {
            return this.matchesContentType(description.getContentType(), contentType);
        }
        return false;
    }
}

