/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.editor;

import edu.mit.story.ui.actions.editor.StoryEditorOperationHistoryAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AsyncStoryModel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.PlatformUI;

public final class StoryEditorRedoAction
extends StoryEditorOperationHistoryAction {
    public StoryEditorRedoAction(IStoryEditor editor) {
        super(editor);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
    }

    protected IStatus runCommand() throws ExecutionException {
        IUndoableOperation op = this.getOperation();
        boolean undoViewer = false;
        if (op instanceof AsyncStoryModel.ModelChangeOperation) {
            undoViewer = ((AsyncStoryModel.ModelChangeOperation)op).didViewerChange();
        }
        if (undoViewer && this.getHistory().canRedo(this.getViewerUndoContext())) {
            this.getStoryModel().setIgnoreChanges(true);
            this.getHistory().redo(this.getViewerUndoContext(), null, null);
            this.getStoryModel().setIgnoreChanges(false);
        }
        return this.getHistory().redo(this.getModelUndoContext(), null, null);
    }

    protected IUndoableOperation getOperation() {
        return this.getHistory().getRedoOperation(this.getModelUndoContext());
    }

    protected boolean shouldBeEnabled() {
        return this.getHistory().canRedo(this.getModelUndoContext());
    }

    protected String getCommandString() {
        return "&Redo {0}";
    }

    protected String getTooltipString() {
        return "Redo {0}";
    }

    protected String getSimpleCommandString() {
        return "&Redo";
    }

    protected String getSimpleTooltipString() {
        return "Redo";
    }
}

