/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class StoryContentLabelProvider
extends StoryModelLabelProvider {
    private Image repImage;
    private Image descImage;
    private Image metaMapImg;
    private Image metaRepImg;
    private Image metaDescImg;

    public StoryContentLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IDescSet) {
            IDescSet descs = (IDescSet)element;
            IRep rep = descs.getRep();
            StyledString result = new StyledString();
            result.append(rep.getName());
            result.append(" - ", StyledString.DECORATIONS_STYLER);
            result.append(rep.getID(), StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (element instanceof IDesc) {
            IDesc desc = (IDesc)element;
            StyledString result = new StyledString();
            result.append(PositionUtils.toString((IHasPosition)desc));
            result.append(' ');
            result.append('(');
            result.append(Long.toString(desc.getID()));
            result.append(')');
            result.append(' ');
            if (desc.getRep() != CharRep.getInstance()) {
                int offset = result.length();
                String data = desc.getRep().serialize(desc.getData());
                result.append(data);
                result.setStyle(offset, data.length(), StyledString.DECORATIONS_STYLER);
            }
            return result;
        }
        if (element instanceof IMetaDataMap) {
            StyledString result = new StyledString();
            result.append("Metadata", StyledString.COUNTER_STYLER);
            return result;
        }
        if (element instanceof IMetaDataSet) {
            IMetaDataSet set = (IMetaDataSet)element;
            StyledString result = new StyledString();
            result.append(set.getMetaRep().getName(), StyledString.COUNTER_STYLER);
            result.append(" - ", StyledString.DECORATIONS_STYLER);
            result.append(set.getMetaRep().getID(), StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (element instanceof IMetaDesc) {
            IMetaDesc metaDesc = (IMetaDesc)element;
            StyledString result = new StyledString();
            result.append(metaDesc.getSerializedData(), StyledString.DECORATIONS_STYLER);
            return result;
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDescSet) {
            return this.getRepImage();
        }
        if (element instanceof IDesc) {
            return this.getDescImage();
        }
        if (element instanceof IMetaDataMap) {
            return this.getMetaMapImg();
        }
        if (element instanceof IMetaDataSet) {
            return this.getMetaRepImg();
        }
        if (element instanceof IMetaDesc) {
            return this.getMetaDescImg();
        }
        return super.getImage(element);
    }

    protected Image getRepImage() {
        if (this.repImage == null) {
            this.repImage = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/representation_tick.gif");
        }
        return this.repImage;
    }

    protected Image getDescImage() {
        if (this.descImage == null) {
            this.descImage = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/description_tick.gif");
        }
        return this.descImage;
    }

    protected Image getMetaMapImg() {
        if (this.metaMapImg == null) {
            this.metaMapImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/timings.gif");
        }
        return this.metaMapImg;
    }

    protected Image getMetaRepImg() {
        if (this.metaRepImg == null) {
            this.metaRepImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/timings.gif");
        }
        return this.metaRepImg;
    }

    protected Image getMetaDescImg() {
        if (this.metaDescImg == null) {
            this.metaDescImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/timing.gif");
        }
        return this.metaDescImg;
    }
}

