/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.ui.model.IAnnotationModelChild;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotationModelChild
extends AnnotationModel
implements IAnnotationModelChild {
    private final IAnnotationModelExtension parent;
    private final RefreshTrigger trigger;
    private final Object triggerKey = new Object();
    private final ChangeNotifier notifier = new ChangeNotifier();

    public AnnotationModelChild(IAnnotationModelExtension parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.trigger = new RefreshTrigger();
        this.parent.addAnnotationModel(this.triggerKey, (IAnnotationModel)this.trigger);
    }

    public void setAnnotating(boolean value) {
        if (value) {
            this.parent.addAnnotationModel((Object)this, (IAnnotationModel)this);
        } else {
            this.parent.removeAnnotationModel((Object)this);
            this.parent.replaceAnnotations(null, null);
            this.trigger.fireModelChanged();
        }
    }

    public boolean isAnnotating() {
        return this.parent.getAnnotationModel((Object)this) == this;
    }

    public void dispose() {
        this.setAnnotating(false);
        this.parent.removeAnnotationModel((Object)this);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }

    protected void fireModelChanged() {
        super.fireModelChanged();
        this.notifier.notifyChangeListeners((Object)this);
    }

    public static AnnotationModelChild createChildAnnotationModel(ITextEditor editor) {
        IEditorInput input = editor.getEditorInput();
        IAnnotationModelExtension parent = (IAnnotationModelExtension)editor.getDocumentProvider().getAnnotationModel((Object)input);
        return new AnnotationModelChild(parent);
    }

    protected class RefreshTrigger
    extends AnnotationModel {
        protected RefreshTrigger() {
        }

        protected void fireModelChanged() {
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
            AnnotationModelChild.this.notifier.notifyChangeListeners((Object)this);
        }
    }
}

