/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import com.google.common.collect.Sets;
import edu.mit.story.core.datamodel.StoryPairModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.model.ICalculateAgreementModel;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateAgreementModel
extends StoryPairModel
implements ICalculateAgreementModel {
    private final IRepSelectionModel repSelectionModel = new RepSelectionModel();

    public CalculateAgreementModel() {
        this.repSelectionModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CalculateAgreementModel.this.fireChanged();
            }
        });
    }

    public boolean setSource(File file) {
        boolean result = super.setSource(file);
        if (result) {
            this.updateReps();
        }
        return result;
    }

    public boolean setTarget(File file) {
        boolean result = super.setTarget(file);
        if (result) {
            this.updateReps();
        }
        return result;
    }

    protected void updateReps() {
        IStoryModel source = this.getSourceModel();
        IStoryModel target = this.getTargetModel();
        if (source == null || target == null) {
            this.repSelectionModel.getSupported().clear();
            return;
        }
        Sets.SetView both = Sets.intersection((Set)source.getSupported(), (Set)target.getSupported());
        this.repSelectionModel.getSupported().retainAll((Collection<?>)both);
        this.repSelectionModel.getSupported().addAll((Collection<IRep>)both);
    }

    @Override
    public Set<IRep> getIncluded() {
        return this.repSelectionModel.getIncluded();
    }

    @Override
    public Set<IRep> getRequired() {
        return this.repSelectionModel.getRequired();
    }

    @Override
    public Set<IRep> getSelected() {
        return this.repSelectionModel.getSelected();
    }

    @Override
    public SortedSet<IRep> getSupported() {
        return this.repSelectionModel.getSupported();
    }

    @Override
    public boolean isIncluded(IRep rep) {
        return this.repSelectionModel.isIncluded(rep);
    }

    @Override
    public boolean isRequired(IRep rep) {
        return this.repSelectionModel.isRequired(rep);
    }

    @Override
    public boolean isSelected(IRep rep) {
        return this.repSelectionModel.isSelected(rep);
    }

    @Override
    public boolean isSupported(IRep rep) {
        return this.repSelectionModel.isSupported(rep);
    }

    @Override
    public void setRequired(IRep rep, boolean isRequired) {
        this.repSelectionModel.setRequired(rep, isRequired);
    }

    @Override
    public void setSelected(IRep rep, boolean isSelected) {
        this.repSelectionModel.setSelected(rep, isSelected);
    }
}

