/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.core.validation.HostnameValidator;
import edu.mit.story.core.validation.IValidator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class HostnameFieldEditor
extends StringFieldEditor {
    private final int fStyle;
    private final IValidator<String> validator = new HostnameValidator();

    public HostnameFieldEditor(String prefName, String labelText, Composite parent) {
        this(prefName, labelText, parent, 256);
    }

    public HostnameFieldEditor(String prefName, String labelText, Composite parent, int style) {
        super(prefName, labelText, parent);
        this.setValidateStrategy(0);
        this.setEmptyStringAllowed(false);
        this.fStyle = this.checkStyle(style);
    }

    protected int checkStyle(int style) {
        int result = style & 0x100;
        if (result != 0) {
            return 256;
        }
        return 512;
    }

    protected boolean checkState() {
        if (this.getTextControl() != null && "".equals(this.getStringValue().trim())) {
            this.setErrorMessage("The hostname cannot be empty");
        }
        return super.checkState();
    }

    protected boolean doCheckState() {
        IMessageProvider message = this.validator.validate((Object)this.getStringValue());
        if (message == null) {
            this.setErrorMessage("");
            return true;
        }
        this.setErrorMessage(message.getMessage());
        return false;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.fStyle == 512) {
            Label label = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            gd.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gd);
        }
        super.doFillIntoGrid(parent, numColumns);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.fStyle == 512) {
            GridData gd = (GridData)this.getTextControl().getLayoutData();
            gd.horizontalSpan = numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd = (GridData)this.getLabelControl().getLayoutData();
            gd.horizontalSpan = numColumns;
            gd.grabExcessHorizontalSpace = true;
        } else {
            super.adjustForNumColumns(numColumns);
        }
    }
}

