/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.viewers;

import edu.mit.story.core.util.Debug;
import edu.mit.story.ui.widgets.List2;
import java.util.ArrayList;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ListViewer2
extends AbstractListViewer {
    private static int style = 2;
    private static int counter = 0;
    private static String boilerPlate = " - An especially long string that one would expect would be wrapped if the window were short enough in the horizontal dimension";
    List2 list;

    public static void main(String[] args) {
        Display display = new Display();
        int numColumns = 6;
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(numColumns, false));
        shell.setText("ListViewer2 Tester");
        shell.setBounds(200, 200, 500, 200);
        final ListViewer2 list = new ListViewer2((Composite)shell, style);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numColumns;
        list.getControl().setLayoutData((Object)gd);
        list.setContentProvider((IContentProvider)new ArrayContentProvider());
        list.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof InputItem) {
                    InputItem item = (InputItem)element;
                    return String.valueOf(item.num) + " : " + item.label;
                }
                return super.getText(element);
            }
        });
        final ArrayList input = new ArrayList();
        list.setInput(input);
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)ListViewer2.this.getSelection();
                Debug.out((String)("selected: " + ((InputItem)sel.getFirstElement()).num));
            }
        });
        Button add = new Button((Composite)shell, 8);
        add.setText("Add");
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String string = boilerPlate;
                int n = counter;
                counter = n + 1;
                input.add(new InputItem(string, n));
                list.refresh();
            }
        });
        Button removeSel = new Button((Composite)shell, 8);
        removeSel.setText("Remove Selection");
        removeSel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ListViewer2.this.getSelection();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    input.remove(o);
                    ++n2;
                }
                ListViewer2.this.refresh();
            }
        });
        Button removeAll = new Button((Composite)shell, 8);
        removeAll.setText("Remove All");
        removeAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                input.clear();
                list.refresh();
            }
        });
        Button selectAll = new Button((Composite)shell, 8);
        selectAll.setText("Select First");
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ListViewer2.this.setSelection(null);
                Object o = ListViewer2.this.getElementAt(0);
                ListViewer2.this.setSelection((ISelection)new StructuredSelection(o));
            }
        });
        Button deselectAll = new Button((Composite)shell, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ListViewer2.this.setSelection(null);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public ListViewer2(Composite parent) {
        this(parent, 2820);
    }

    public ListViewer2(Composite parent, int style) {
        this(new List2(parent, style));
    }

    public ListViewer2(List2 list) {
        this.list = list;
        this.hookControl((Control)list);
    }

    public List2 getList() {
        return this.list;
    }

    public Control getControl() {
        return this.list;
    }

    public void reveal(Object element) {
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        String label = labelProvider.getText(element);
        int idx = this.list.indexOf(label);
        this.list.setTopIndex(idx);
    }

    protected void listAdd(String string, int index) {
        this.list.add(string, index);
    }

    protected void listDeselectAll() {
        this.list.deselectAll();
    }

    protected int listGetItemCount() {
        return this.list.getItemCount();
    }

    protected int[] listGetSelectionIndices() {
        return this.list.getSelectionIndices();
    }

    protected void listRemove(int index) {
        this.list.remove(index);
    }

    protected void listRemoveAll() {
        this.list.removeAll();
    }

    protected void listSetItem(int index, String string) {
        this.list.setItem(index, string);
    }

    protected void listSetItems(String[] labels) {
        this.list.setItems(labels);
    }

    protected void listSetSelection(int[] ixs) {
        this.list.setSelection(ixs);
    }

    protected void listShowSelection() {
        this.list.showSelection();
    }

    protected static class InputItem {
        public String label;
        public int num;

        public InputItem(String label, int num) {
            this.label = label;
            this.num = num;
        }
    }
}

