/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.datamodel.BatchTargetModel;
import edu.mit.story.core.datamodel.IBatchTargetModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.BatchStoryTargetController;
import edu.mit.story.ui.controllers.IBatchTargetController;
import edu.mit.story.ui.handlers.GenerateTextsHandler;
import edu.mit.story.ui.ops.BatchModifyStoryOperation;
import edu.mit.story.ui.wizards.page.SelectTargetBatchPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class GenerateTextsWizard
extends Wizard {
    private final IModelChange change;
    private final IBatchTargetController<IBatchTargetModel> controller;
    protected SelectTargetBatchPage selectTargetsPage;
    protected IStructuredSelection selection;

    public GenerateTextsWizard(GenerateTextsHandler.GenerationTarget group, ISelection selection, IModelChange change) {
        IStructuredSelection sel;
        if (change == null) {
            throw new NullPointerException();
        }
        this.setWindowTitle("Generate Texts: " + group.getName());
        this.setNeedsProgressMonitor(true);
        BatchTargetModel model = new BatchTargetModel();
        BatchStoryTargetController<BatchTargetModel> controller = new BatchStoryTargetController<BatchTargetModel>(model, group.getFileExtension());
        if (selection != null && (sel = SelectionUtils.castAsStructuredSelection(selection)) != null) {
            for (Object obj : sel.toList()) {
                if (!(obj instanceof IResource)) continue;
                controller.addAllTargets((IResource)obj);
            }
        }
        this.controller = controller;
        this.change = change;
    }

    public void addPages() {
        this.selectTargetsPage = new SelectTargetBatchPage(this.controller);
        this.addPage((IWizardPage)this.selectTargetsPage);
    }

    public boolean performFinish() {
        IBatchTargetModel m = this.controller.getModel();
        BatchModifyStoryOperation op = new BatchModifyStoryOperation(m.getTargets(), this.change, m.getOutputFile());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            LogUtils.logError((Plugin)StoryUIPlugin.getDefault(), (Throwable)e);
            return false;
        }
        return true;
    }
}

