/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.problems;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplyTaggedVerbProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.core.problem.multipleSemroles";

    public MultiplyTaggedVerbProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(SemRoleRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("multiply tagged verb");
        this.setSeverity(1);
        this.setDescs(descs);
        this.setCheck(ID);
        DescSet ds = new DescSet(SemRoleRep.getInstance(), descs);
        if (ds.size() < 2) {
            throw new IllegalArgumentException();
        }
        ISemRole semrole = (ISemRole)((IDesc)ds.first()).getData();
        IDesc verb = (IDesc)semrole.getPredicate().getTokens().first();
        IToken verbToken = (IToken)verb.getData();
        this.setDescs(Collections.singleton(verb));
        this.setPosition((IHasPosition)verb);
        StringBuilder sb = new StringBuilder();
        sb.append("The verb '");
        sb.append(verbToken.getSurface());
        sb.append("' has ");
        sb.append(Integer.toString(ds.size()));
        sb.append(" semantic roles");
        this.setDescription(sb.toString());
    }
}

