/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.rules;

import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.problems.NoAspectualLinkProblem;
import edu.mit.semantics.core.rep.timelink.problems.NoTemporalLinkProblem;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalAspectualLinksRule
extends AbstractBuildRule {
    public static final String ID = TemporalAspectualLinksRule.class.getCanonicalName();

    public TemporalAspectualLinksRule() {
        super(TimeLinkRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> noTemporalLink = new HashSet<IDesc>((Collection<IDesc>)model.getData().getDescriptions(Timex3Rep.getInstance()));
        HashSet<IDesc> noAspectualLink = new HashSet<IDesc>();
        for (IDesc eventDesc : model.getData().getDescriptions(EventRep.getInstance())) {
            IEvent event = (IEvent)eventDesc.getData();
            if (event.getEventClass() == EventClass.ASPECTUAL) {
                noAspectualLink.add(eventDesc);
                continue;
            }
            noTemporalLink.add(eventDesc);
        }
        for (IDesc linkDesc : model.getData().getDescriptions(TimeLinkRep.getInstance())) {
            ITimeLink link = (ITimeLink)linkDesc.getData();
            switch (link.getRelationType().getType()) {
                case TEMPORAL: {
                    noTemporalLink.remove(link.getSource());
                    noTemporalLink.remove(link.getRelated());
                    break;
                }
                case ASPECTUAL: {
                    noAspectualLink.remove(link.getSource());
                }
            }
        }
        Iterator i = noTemporalLink.iterator();
        while (i.hasNext()) {
            if (!CheckMetaRep.isChecked((IDesc)((IDesc)i.next()), (String)"edu.mit.semantics.timelink.problem.noTemporalLink")) continue;
            i.remove();
        }
        if (noTemporalLink.isEmpty() && noAspectualLink.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc desc : noTemporalLink) {
            result.add((Object)new NoTemporalLinkProblem(desc, this.getID()));
        }
        for (IDesc desc : noAspectualLink) {
            result.add((Object)new NoAspectualLinkProblem(desc, this.getID()));
        }
        return result;
    }
}

