/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IChangeSetMergeInputProvider;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.wizards.MergeWizardDesktopDownloadPage;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DesktopDownloadMergeInputProvider
implements IChangeSetMergeInputProvider {
    private MergeWizardDesktopDownloadPage downloadPage;
    private WizardPage[] wizardPages;

    public boolean enabledForMultipleSelection() {
        return true;
    }

    public String getDescription() {
        return "Use this method to merge the revisions associated with one or more CollabNet artifacts.  Typically this option would be used to backport fixes to a release branch or similar scenarios where all of the changes associated with an artifact need to be merged from one location to another.";
    }

    public Image getImage() {
        return Activator.getImage("changesets.png");
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        return null;
    }

    public int getSequence() {
        return 20;
    }

    public String getText() {
        return "Change-set based merge";
    }

    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.downloadPage = new MergeWizardDesktopDownloadPage("download", "Change-set merge", Activator.getDefault().getImageDescriptor("collabnet_wizban.gif"));
            WizardPage[] pages = new WizardPage[]{this.downloadPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    public boolean hideDepth() {
        return false;
    }

    public boolean hideForce() {
        return false;
    }

    public boolean hideIgnoreAncestry() {
        return false;
    }

    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Download Desktop", (String)"This is where you will download this stuff.");
        return false;
    }

    public void setDescription(String description) {
    }

    public void setImage(Image image) {
    }

    public void setSequence(int sequence) {
    }

    public void setText(String text) {
    }

    public boolean showBestPracticesPage() {
        return false;
    }

    public boolean showOptionsPage() {
        return false;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }
}

