/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.content;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.LinkedList;

public class EventContentProvider
extends StoryEditorContentProvider {
    public static final int CHILD_TYPE_HEAD = 1;
    public static final int CHILD_TYPE_CARDINALITY = 2;
    public static final int CHILD_TYPE_POLARITY = 3;
    public static final int CHILD_TYPE_MODALITY = 4;
    public static final int CHILD_TYPE_FEATURE = 5;

    public EventContentProvider(IStoryEditor input) {
        super(EventRep.getInstance(), input, "(no events)");
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IDesc) {
            return true;
        }
        if (element instanceof IEvent) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        Object[] defaultChildren = super.getChildren(element);
        Object parent = element;
        IDesc d = null;
        if (parent instanceof IDesc) {
            d = (IDesc)parent;
            parent = d.getData();
        }
        if (parent instanceof IEvent) {
            IEvent e = (IEvent)parent;
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(EventContentProvider.makeChild((int)5, (Object)element, (Object)e.getEventClass()));
            result.add(EventContentProvider.makeChild((int)1, (Object)element, (Object)e.getHeadTokens()));
            result.add(EventContentProvider.makeChild((int)5, (Object)element, (Object)e.getPOS()));
            result.add(EventContentProvider.makeChild((int)5, (Object)element, (Object)e.getTense()));
            result.add(EventContentProvider.makeChild((int)5, (Object)element, (Object)e.getAspect()));
            if (e.getPolarityTokens() != null) {
                result.add(EventContentProvider.makeChild((int)3, (Object)element, (Object)e.getPolarityTokens()));
            } else if (!e.getPolarity()) {
                result.add(EventContentProvider.makeChild((int)3, (Object)element, (Object)e.getPolarity()));
            }
            if (e.getCardinalityTokens() != null) {
                result.add(EventContentProvider.makeChild((int)2, (Object)element, (Object)e.getCardinalityTokens()));
            } else if (e.getCardinality() != 1) {
                result.add(EventContentProvider.makeChild((int)2, (Object)element, (Object)e.getCardinality()));
            }
            if (e.getModalityTokens() != null) {
                result.add(EventContentProvider.makeChild((int)4, (Object)element, (Object)e.getModalityTokens()));
            }
            if (defaultChildren != null) {
                Object[] objectArray = defaultChildren;
                int n = defaultChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    result.add(child);
                    ++n2;
                }
            }
            return result.toArray();
        }
        return defaultChildren;
    }
}

