/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.problems;

import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class MissingPOSTagProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.missingStemPOS";

    public MissingPOSTagProblem(IDesc stemDesc, String buildRuleID) {
        super(StemRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Missing POS for Stem");
        this.setSeverity(2);
        this.setDescs(Collections.singleton(stemDesc));
        IDescSet senses = this.getDescs().getDescriptions(StemRep.getInstance());
        if (senses.size() != 1) {
            throw new IllegalArgumentException();
        }
        IDesc d = (IDesc)senses.first();
        this.setPosition((IHasPosition)d);
        IStem stem = (IStem)d.getData();
        IBaseToken word = (IBaseToken)stem.getWord().getData();
        this.setDescription("The stem for '" + word.getSurface() + "' is missing a pos tag; please recalculate it");
    }
}

