/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.manager;

import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.TagSet;
import edu.mit.parsing.core.rep.tag.tagset.manager.ITagsetDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsetDescriptor
implements ITagsetDescriptor {
    private final ITagset tagset;
    private final String corpus;
    private final String corpusPath;
    private final String fullPath;

    public TagsetDescriptor(ITagset tagset, String corpusName, String corpusPath) {
        if (tagset == null) {
            throw new NullPointerException();
        }
        IProject corpus = ResourcesPlugin.getWorkspace().getRoot().getProject(corpusName);
        IFile tagsetFile = corpus.getFile(corpusPath);
        this.tagset = tagset;
        this.corpus = corpus.getName();
        this.corpusPath = tagsetFile.getProjectRelativePath().toPortableString();
        this.fullPath = tagsetFile.getFullPath().toPortableString();
    }

    public String getID() {
        return this.tagset.getID();
    }

    public String getName() {
        return this.tagset.getName();
    }

    public String getDescription() {
        return this.tagset.getDescription();
    }

    @Override
    public String getCorpus() {
        return this.corpus;
    }

    @Override
    public String getCorpusPath() {
        return this.corpusPath;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public Class<? extends ITagset> getCreatableClass() {
        return TagSet.class;
    }

    public ITagset create() {
        return this.tagset;
    }

    public String getClassAttribute() {
        throw new UnsupportedOperationException();
    }

    public IConfigurationElement getConfigurationElement() {
        throw new UnsupportedOperationException();
    }
}

