/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.repo.RepositoryComparator;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.util.AdaptableList;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;

public class CheckoutWizardLocationPage
extends WizardPage {
    private TableViewer table;
    private Button newButton;
    private Button existingButton;
    private ISVNRepositoryLocation result;

    public CheckoutWizardLocationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.newButton = new Button(outerContainer, 16);
        this.newButton.setText(Policy.bind("CheckoutWizardLocationPage.new"));
        this.existingButton = new Button(outerContainer, 16);
        this.existingButton.setText(Policy.bind("CheckoutWizardLocationPage.existing"));
        this.table = this.createTable(outerContainer, 1);
        this.table.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheckoutWizardLocationPage.this.result = (ISVNRepositoryLocation)((IStructuredSelection)CheckoutWizardLocationPage.this.table.getSelection()).getFirstElement();
                wizard.setLocation(CheckoutWizardLocationPage.this.result);
                CheckoutWizardLocationPage.this.setPageComplete(true);
            }
        });
        this.existingButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CheckoutWizardLocationPage.this.newButton.getSelection()) {
                    CheckoutWizardLocationPage.this.table.getTable().setEnabled(false);
                    CheckoutWizardLocationPage.this.result = null;
                } else {
                    CheckoutWizardLocationPage.this.table.getTable().setEnabled(true);
                    CheckoutWizardLocationPage.this.result = (ISVNRepositoryLocation)((IStructuredSelection)CheckoutWizardLocationPage.this.table.getSelection()).getFirstElement();
                    wizard.setLocation(CheckoutWizardLocationPage.this.result);
                }
                CheckoutWizardLocationPage.this.setPageComplete(CheckoutWizardLocationPage.this.newButton.getSelection() || !CheckoutWizardLocationPage.this.table.getSelection().isEmpty());
            }
        });
        this.setMessage(Policy.bind("CheckoutWizardLocationPage.text"));
        this.setControl((Control)outerContainer);
        this.refreshLocations();
    }

    public void refreshLocations() {
        ISVNRepositoryLocation[] locations = SVNUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations(null);
        Arrays.sort(locations, new RepositoryComparator());
        AdaptableList input = new AdaptableList((IAdaptable[])locations);
        this.table.setInput((Object)input);
        if (locations.length == 0) {
            this.newButton.setSelection(true);
            this.existingButton.setSelection(false);
            this.table.getTable().setEnabled(false);
            this.setPageComplete(true);
        } else {
            this.existingButton.setSelection(true);
            this.newButton.setSelection(false);
            this.table.getTable().setEnabled(true);
        }
    }

    protected TableViewer createTable(Composite parent, int span) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        return new TableViewer(table);
    }

    public ISVNRepositoryLocation getLocation() {
        return this.result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public boolean createNewLocation() {
        return this.newButton.getSelection();
    }

    public boolean canFlipToNextPage() {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        if (wizard != null) {
            return this.isPageComplete() && wizard.getNextPage((IWizardPage)this, false) != null;
        }
        return super.canFlipToNextPage();
    }
}

