/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.handlers;

import edu.mit.discourse.core.rep.coref.Coref;
import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.changes.MoveRefexpModelChange;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.dialogs.CorefSelectionDialog;
import edu.mit.discourse.ui.dialogs.RefExpSelectionDialog;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddToCorefHandler
extends AbstractHandler {
    public void setEnabled(Object context) {
        IStoryEditor editor;
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor && (editor = (IStoryEditor)var).supports(CorefRep.getInstance())) {
            IHasPosition selection = editor.getSelectedRange();
            IDescSet refexp = editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance());
            this.setBaseEnabled(!(refexp = refexp.openSet(selection)).isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MoveRefexpModelChange change;
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!editor.getStoryModel().supports(CorefRep.getInstance())) {
            return null;
        }
        IHasPosition sel = editor.getSelectedRange();
        IDescSet refexps = editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance()).closedSet(sel);
        if (refexps.isEmpty()) {
            refexps = editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance()).openSet(sel);
        }
        IDesc refexpDesc = null;
        switch (refexps.size()) {
            case 0: {
                return null;
            }
            case 1: {
                refexpDesc = (IDesc)refexps.first();
                break;
            }
            default: {
                refexpDesc = RefExpSelectionDialog.open(editor, null, null, sel);
            }
        }
        IRefExp refexp = (IRefExp)refexpDesc.getData();
        String message = "Please select a coreference relationship to which to assign the referring expression '" + refexp.getDisplayText() + "'\nPress Cancel or Escape for none";
        Object coref = CorefSelectionDialog.open(editor, null, message, (IHasPosition)refexpDesc);
        if (coref == null) {
            return null;
        }
        if (coref instanceof IDesc) {
            IDesc corefDesc = (IDesc)coref;
            change = new MoveRefexpModelChange(corefDesc, refexpDesc);
        } else if (coref instanceof String) {
            String name = (String)coref;
            Coref newCoref = new Coref(name, Collections.singleton(refexpDesc));
            IHasPosition p = newCoref.calculatePosition();
            long id = editor.getStoryModel().getNextID();
            Desc corefDesc = new Desc(id, CorefRep.getInstance(), p, (IData)newCoref, null);
            refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)corefDesc, (IMetaData)Origin.USER_SPECIFIED));
            refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)corefDesc, (IMetaData)new Timing(start, "user")));
            change = new AddDescriptionsChange((IDesc)corefDesc);
        } else {
            throw new IllegalStateException();
        }
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

