/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc.factory;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.factory.FactoryNotInitializedException;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.DescPositionChange;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.position.StoryPosition;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.ImmutableRepSet;
import edu.mit.story.core.rep.character.changes.CharChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescFactory
extends Registered
implements IDescFactory {
    private boolean isInitialized = false;
    private Object initSync = new Object();
    private final IRep fRep;
    private final IRepSet fReadReps;
    private IConfiguration fConfig = null;
    private IConfigDescriptor fConfigDesc = null;

    public AbstractDescFactory(IRep rep, IRep requiredRep) {
        this(rep, requiredRep == null ? null : Collections.singleton(requiredRep));
    }

    public AbstractDescFactory(IRep rep, IRep ... requiredReps) {
        this(rep, Arrays.asList(requiredReps));
    }

    public AbstractDescFactory(IRep rep, Collection<? extends IRep> requiredReps) {
        if (rep == null) {
            throw new NullPointerException();
        }
        this.fRep = rep;
        this.fReadReps = requiredReps != null ? new ImmutableRepSet(requiredReps) : new ImmutableRepSet();
    }

    @Override
    public IRep getRep() {
        return this.fRep;
    }

    @Override
    public IRepSet getRequiredReps() {
        return this.fReadReps;
    }

    @Override
    public boolean configure(IConfiguration config) {
        if (this.isInitialized) {
            return false;
        }
        IConfigDescriptor cDesc = this.getConfigurationDescriptor();
        if (cDesc == null) {
            return true;
        }
        if (this.fConfig == null) {
            this.fConfig = cDesc.createDefault();
        }
        this.fConfig.configure(config);
        return true;
    }

    @Override
    public IConfiguration getConfiguration() {
        IConfigDescriptor desc;
        if (this.fConfig == null && (desc = this.getConfigurationDescriptor()) != null) {
            this.fConfig = desc.createDefault();
        }
        return this.fConfig == null ? null : this.fConfig.clone();
    }

    @Override
    public IConfigDescriptor getConfigurationDescriptor() {
        if (this.fConfigDesc == null) {
            this.fConfigDesc = this.createConfigurationDescriptor();
            if (this.fConfigDesc != null) {
                if (this.fConfigDesc.getID() == null) {
                    this.fConfigDesc.setID(this.getID());
                }
                if (this.fConfigDesc.getName() == null) {
                    this.fConfigDesc.setName(this.getName());
                }
                if (this.fConfigDesc.getDescription() == null) {
                    this.fConfigDesc.setDescription(this.getDescription());
                }
            }
        }
        return this.fConfigDesc;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(IStoryModel model) {
        Object object = this.initSync;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
            if (this.getID() == null) {
                return;
            }
            this.isInitialized = this.doInit(model);
        }
    }

    protected boolean doInit(IStoryModel data) {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void checkInit() {
        if (!this.isInitialized()) {
            throw new FactoryNotInitializedException();
        }
    }

    @Override
    public void dispose(IStoryModel model) {
    }

    @Override
    public IDescSet calculateDescs(IHasPosition range, IStoryModel provider) {
        this.checkInit();
        if (range == null | provider == null) {
            return null;
        }
        return this.doCalculateDescriptions(range, provider);
    }

    @Override
    public StoryChangeEvent applyChanges(StoryChangeEvent event) {
        this.checkInit();
        if (event == null) {
            return null;
        }
        StoryChangeEvent result = null;
        CharChange charChange = null;
        IModelChange doChange = event.doChange;
        CharChange charChange2 = charChange = doChange instanceof CharChange ? (CharChange)doChange : null;
        if (charChange == null) {
            CompositeModelChange composite = doChange instanceof CompositeModelChange ? (CompositeModelChange)doChange : null;
            doChange = composite == null ? null : composite.getChildren()[0];
            CharChange charChange3 = charChange = doChange instanceof CharChange ? (CharChange)doChange : null;
        }
        if (charChange != null) {
            result = this.adjustForCharChange(charChange, event.getSource(), this.getRep(), event.provider);
        }
        result = ChangeUtils.combine(result, this.removeShortDescriptions(event.provider.getData().getDescriptions(this.getRep()), event));
        Iterator<IRep> i = this.getRep().anteIterator();
        while (i.hasNext()) {
            Change change = event.getChange(i.next());
            if (change == null || !change.changed(Flag.DESCS)) continue;
            if (this.getRep().isStructured()) {
                result = ChangeUtils.combine(result, this.updateEmbeddedDescs(this.getRep(), event));
            }
            return ChangeUtils.combine(this.doApplyChanges(event), result);
        }
        return result;
    }

    protected StoryChangeEvent removeShortDescriptions(IDescSet descSet, StoryChangeEvent event) {
        int minLength = descSet.getRep().getMinimumDescriptionLength();
        ArrayList<IDesc> changed = null;
        Iterator i = descSet.iterator();
        while (i.hasNext()) {
            IDesc desc = (IDesc)i.next();
            if (desc.getLength() >= minLength) continue;
            if (changed == null) {
                changed = new ArrayList<IDesc>();
            }
            changed.add(desc);
            i.remove();
        }
        if (changed == null) {
            return null;
        }
        this.saveDeleted(changed, event.provider.getData());
        StoryChangeEventIntegrator integrator = event.createIntegrator();
        integrator.descriptionsRemoved((Collection<? extends IDesc>)changed);
        return integrator.asEvent();
    }

    protected abstract IDescSet doCalculateDescriptions(IHasPosition var1, IStoryModel var2);

    protected abstract StoryChangeEvent doApplyChanges(StoryChangeEvent var1);

    protected StoryChangeEvent updateEmbeddedDescs(IRep rep, StoryChangeEvent event) {
        if (rep.getDataFormat() == null || !IStructuredData.class.isAssignableFrom(rep.getDataFormat())) {
            return null;
        }
        if (!event.getModel().supports(rep)) {
            return null;
        }
        IStoryData pData = event.getModel().getData();
        IDescSet descSet = pData.getDescriptions(rep);
        if (descSet.isEmpty()) {
            return null;
        }
        IntervalSet regions = new IntervalSet();
        Iterator<IRep> i = rep.anteIterator();
        while (i.hasNext()) {
            Change change = event.getChange(i.next());
            if (change == null) continue;
            for (IFlag iFlag : Flag.DESCS) {
                IHasPositionSet descs = change.getChanges(iFlag);
                if (descs == null) continue;
                regions.addAll(descs);
            }
        }
        if (regions.isEmpty()) {
            return null;
        }
        HashSet<IDesc> targets = new HashSet<IDesc>();
        for (IHasPosition iHasPosition : regions) {
            targets.addAll(descSet.closedSet(iHasPosition));
        }
        if (targets.isEmpty()) {
            return null;
        }
        StoryChangeEventIntegrator integrator = event.createIntegrator();
        LinkedList<IDesc> removed = new LinkedList<IDesc>();
        for (IDesc target : targets) {
            IStructuredData oldData = (IStructuredData)target.getData();
            IStructuredData newData = null;
            try {
                newData = oldData.recalculate(target, event.getModel());
            }
            catch (Exception e) {
                Status status = new Status(4, "edu.mit.story.core", "An error occured when recalculating " + target.toString(), (Throwable)e);
                StoryPlugin.getDefault().getLog().log((IStatus)status);
            }
            if (newData == oldData) continue;
            descSet.remove(target);
            integrator.descriptionRemoved(target);
            removed.add(target);
            if (newData == null) continue;
            IHasPosition iHasPosition = newData.calculatePosition();
            target = new Desc(target.getID(), rep, iHasPosition, newData, target.getMetaData());
            descSet.add(target);
            integrator.descriptionAdded(target);
        }
        if (integrator.isNull()) {
            return null;
        }
        this.saveDeleted(removed, event.provider.getData());
        return integrator.asEvent();
    }

    protected void saveDeleted(Collection<? extends IDesc> deleted, IStoryData data) {
        if (deleted == null) {
            return;
        }
        for (IDesc iDesc : deleted) {
            for (IMetaDataSet set : iDesc.getMetaData().values()) {
                if (!set.getMetaRep().saveOnDelete()) continue;
                data.getMetadata().addAllDescs(set);
            }
        }
    }

    protected StoryChangeEvent adjustForCharChange(CharChange change, Object source, IRep rep, IMutableStoryModel model) {
        SimplePosition replace = new SimplePosition(change.replaceOffset, change.replacedLength);
        int insertLength = change.insertLength;
        boolean needsInit = true;
        ArrayList<Long> ids = null;
        ArrayList<Integer> lengths = null;
        ArrayList<Integer> offsets = null;
        for (IDesc desc : model.getData().getDescriptions(rep)) {
            boolean replaceEndsAfter;
            SimplePosition oldPosition = new SimplePosition(desc);
            StoryPosition newPosition = new StoryPosition(desc);
            boolean replaceStartsBefore = replace.getOffset() < newPosition.getOffset();
            boolean bl = replaceEndsAfter = newPosition.getRightOffset() < replace.getRightOffset();
            if (replaceStartsBefore && replaceEndsAfter) {
                newPosition.setOffset(replace.getOffset());
                newPosition.setLength(0);
            } else if (PositionUtils.equalAsPositions(newPosition, replace) && newPosition.getLength() > 0) {
                newPosition.setOffset(replace.getOffset());
                newPosition.setLength(insertLength);
            } else {
                int myEnd;
                if (replace.getLength() > 0) {
                    int yourEnd = Math.max(replace.getOffset(), replace.getRightOffset() - 1);
                    myEnd = Math.max(newPosition.getOffset(), newPosition.getRightOffset() - 1);
                    if (myEnd >= replace.getOffset()) {
                        if (newPosition.getOffset() <= replace.getOffset()) {
                            if (yourEnd <= myEnd) {
                                newPosition.setLength(Math.max(0, newPosition.getLength() - replace.getLength()));
                            } else {
                                newPosition.setLength(Math.max(0, newPosition.getLength() + replace.getOffset() - myEnd - 1));
                            }
                        } else if (newPosition.getOffset() > replace.getOffset()) {
                            if (yourEnd < newPosition.getOffset()) {
                                newPosition.setOffset(Math.max(0, newPosition.getOffset() - replace.getLength()));
                            } else {
                                newPosition.setOffset(Math.max(0, replace.getOffset()));
                                newPosition.setLength(Math.max(0, newPosition.getRightOffset() - yourEnd - 1));
                            }
                        }
                    }
                }
                if (insertLength > 0) {
                    myEnd = newPosition.getRightOffset() - (replace.getLength() > 0 ? 1 : 0);
                    myEnd = Math.max(newPosition.getOffset(), myEnd);
                    if (myEnd > replace.getOffset()) {
                        boolean adjustLength;
                        if (replace.getLength() == 0) {
                            adjustLength = newPosition.getOffset() < replace.getOffset();
                        } else {
                            boolean bl2 = adjustLength = newPosition.getOffset() <= replace.getOffset() && oldPosition.getOffset() <= replace.getOffset();
                        }
                        if (adjustLength) {
                            newPosition.setLength(newPosition.getLength() + insertLength);
                        } else {
                            newPosition.setOffset(newPosition.getOffset() + insertLength);
                        }
                    }
                }
            }
            if (PositionUtils.equalAsPositions(newPosition, oldPosition)) continue;
            if (needsInit) {
                ids = new ArrayList<Long>();
                lengths = new ArrayList<Integer>();
                offsets = new ArrayList<Integer>();
                needsInit = false;
            }
            ids.add(desc.getID());
            offsets.add(newPosition.getOffset());
            lengths.add(newPosition.getLength());
        }
        if (needsInit) {
            return null;
        }
        DescPositionChange modelChange = new DescPositionChange(ids, offsets, lengths);
        return modelChange.apply(source, model);
    }
}

