/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc.factory;

import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IMutablePosition;
import edu.mit.story.core.position.PositionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedData<T extends IData>
implements IHasPosition,
IMutablePosition {
    public int offset;
    public int length;
    public int right;
    public T data;
    private boolean allowsNullData;

    public IndexedData(IHasPosition position, T data) {
        this(position.getOffset(), position.getLength(), data);
    }

    public IndexedData(int offset, int length, T data) {
        this(offset, length, data, true);
    }

    protected IndexedData(int offset, int length, T data, boolean allowsNullData) {
        PositionUtils.assertValidPosition(offset, length);
        this.offset = offset;
        this.length = length;
        this.right = offset + length;
        this.allowsNullData = allowsNullData;
        if (!allowsNullData && data == null) {
            throw new NullPointerException();
        }
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public boolean setData(T newData) {
        if (!this.allowsNullData && newData == null) {
            throw new NullPointerException();
        }
        if (this.dataEqual(newData)) {
            return false;
        }
        this.data = newData;
        return true;
    }

    @Override
    public boolean setOffset(int newOffset) {
        if (this.offset == newOffset) {
            return false;
        }
        this.offset = newOffset;
        this.right = this.offset + this.length;
        return true;
    }

    @Override
    public boolean setLength(int newLength) {
        if (this.length == newLength) {
            return false;
        }
        this.length = newLength;
        this.right = this.offset + this.length;
        return true;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getRightOffset() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexedData) {
            IndexedData idxData = (IndexedData)o;
            if (this.offset != idxData.getOffset()) {
                return false;
            }
            if (this.length != idxData.getLength()) {
                return false;
            }
            return this.dataEqual(idxData.getData());
        }
        if (o instanceof IDesc) {
            IDesc desc = (IDesc)o;
            if (this.offset != desc.getOffset()) {
                return false;
            }
            if (this.length != desc.getLength()) {
                return false;
            }
            return this.dataEqual(desc.getData());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = prime + this.offset;
        hash = hash * prime + this.length;
        hash = hash * prime + this.dataHash();
        return hash * prime;
    }

    public String toString() {
        return String.valueOf(this.getData().toString()) + '@' + PositionUtils.toString(this);
    }

    public boolean dataEqual(Object descData) {
        if (this.getData() == null) {
            return descData == null;
        }
        return this.getData().equals(descData);
    }

    public int dataHash() {
        if (this.getData() == null) {
            return 0;
        }
        return this.getData().hashCode();
    }

    public boolean replaces(IDesc desc) {
        return PositionUtils.equalAsPositions(this, desc);
    }
}

