/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMetadataChange
extends AbstractModelChange {
    private final IMetaRep<?> metaRep;
    private final long id;
    private final IRep rep;
    private final IMetaData data;
    private final IMetaDataMap metadata;

    public <D extends IMetaData> AddMetadataChange(IMetaRep<D> metaRep, IRep rep, D data) {
        super("Add Metadata");
        if (metaRep == null) {
            throw new NullPointerException();
        }
        if (rep == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.metaRep = metaRep;
        this.rep = rep;
        this.data = data;
        this.id = -1L;
        this.metadata = null;
    }

    public <D extends IMetaData> AddMetadataChange(IMetaRep<D> metaRep, long id, D data) {
        super("Add Metadata");
        if (metaRep == null) {
            throw new NullPointerException();
        }
        if (id < 0L) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.metaRep = metaRep;
        this.id = id;
        this.data = data;
        this.rep = null;
        this.metadata = null;
    }

    public AddMetadataChange(IMetaDesc<?> d) {
        this(Collections.singleton(d));
    }

    public AddMetadataChange(Iterable<? extends IMetaDesc<?>> c) {
        super("Add Metadata");
        this.metadata = new MetaDataMap(c);
        this.id = -1L;
        this.rep = null;
        this.metaRep = null;
        this.data = null;
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        LinkedHashMap changes = new LinkedHashMap();
        if (this.metadata != null) {
            this.processList(changes, model);
        } else if (this.rep != null) {
            this.processRep(changes, model);
        } else if (this.id >= 0L) {
            this.processDesc(changes, model);
        }
        if (changes.isEmpty()) {
            return null;
        }
        StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(source, model);
        integrator.metadataAdded(changes);
        return integrator.asEvent();
    }

    protected void processDesc(Map<IMetaDesc<?>, IHasPosition> changes, IMutableStoryModel model) {
        IDesc desc = model.getData().getDescription(this.id);
        if (desc == null) {
            return;
        }
        MetaDesc<IMetaData> metaDesc = new MetaDesc<IMetaData>(this.metaRep, desc, this.data);
        desc.getMetaData().addDesc(metaDesc);
        changes.put(metaDesc, desc);
    }

    protected void processRep(Map<IMetaDesc<?>, IHasPosition> changes, IMutableStoryModel model) {
        MetaDesc<IMetaData> metaDesc = new MetaDesc<IMetaData>(this.metaRep, this.rep, this.data);
        model.getData().getMetadata().addDesc(metaDesc);
        changes.put(metaDesc, model);
    }

    protected void processList(Map<IMetaDesc<?>, IHasPosition> changes, IMutableStoryModel model) {
        IStoryData data = model.getData();
        for (IMetaDataSet set : this.metadata.values()) {
            for (IMetaDesc md : set) {
                IDesc d;
                if (md.getDescriptionID() >= 0L && (d = data.getDescriptions(md.getRep()).getDescription(md.getDescriptionID())) != null) {
                    d.getMetaData().addDesc(md);
                    changes.put(md, d);
                    continue;
                }
                data.getMetadata().addDesc(md);
                changes.put(md, model);
            }
        }
    }
}

