/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InStepIterator<P extends IHasPosition>
implements Iterator<List<List<P>>> {
    protected List<List<P>> next = null;
    protected IHasPosition lastPos = null;
    protected IHasPosition nextPos = null;
    protected List<List<P>> unmatched = null;
    protected final List<P> leadingEdge;
    protected final List<Collection<? extends P>> sets;
    protected final List<Iterator<? extends P>> itrs;

    public InStepIterator(Collection<? extends P> ... sets) {
        if (sets.length == 0) {
            throw new IllegalArgumentException();
        }
        this.sets = Arrays.asList(sets);
        this.itrs = new ArrayList<Iterator<? extends P>>(sets.length);
        int i = 0;
        while (i < sets.length) {
            this.itrs.add(sets[i].iterator());
            ++i;
        }
        this.leadingEdge = new ArrayList<P>(sets.length);
        int i2 = 0;
        while (i2 < this.itrs.size()) {
            Iterator<P> itr = this.itrs.get(i2);
            this.leadingEdge.add(itr.hasNext() ? (IHasPosition)itr.next() : null);
            ++i2;
        }
        this.loadNext();
    }

    public List<List<P>> getUnmatched() {
        return this.unmatched;
    }

    public IHasPosition getLastPosition() {
        return this.lastPos;
    }

    public IHasPosition getNextPosition() {
        return this.nextPos;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<List<P>> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        List<List<P>> result = this.next;
        this.loadNext();
        return result;
    }

    protected void loadNext() {
        this.lastPos = this.nextPos;
        this.nextPos = this.findMax();
        this.reset();
        this.fillNext(this.nextPos, this.isLeadEven());
        while (this.isNextUneven()) {
            this.nextPos = this.findMax();
            this.advanceTo(this.nextPos, this.isLeadEven());
        }
        this.voidEmptyNext();
    }

    protected IHasPosition findMax() {
        IHasPosition result = null;
        for (IHasPosition p : this.leadingEdge) {
            if (p == null) {
                return null;
            }
            if (result == null) {
                result = p;
            }
            result = PositionUtils.maxPosition(result, p);
        }
        return result;
    }

    protected void reset() {
        this.next = new ArrayList<List<P>>(this.sets.size());
        int i = 0;
        while (i < this.sets.size()) {
            this.next.add(Collections.emptyList());
            ++i;
        }
        this.unmatched = new ArrayList<List<P>>(this.sets.size());
        i = 0;
        while (i < this.sets.size()) {
            this.unmatched.add(Collections.emptyList());
            ++i;
        }
    }

    protected void fillNext(IHasPosition p, boolean capture) {
        int i = 0;
        while (i < this.itrs.size()) {
            IHasPosition lead = (IHasPosition)this.leadingEdge.get(i);
            List<P> list = this.next.get(i);
            Iterator<P> itr = this.itrs.get(i);
            while (this.shouldContinue(lead, p, capture)) {
                if (list.size() == 0) {
                    list = new ArrayList<P>();
                    this.next.set(i, list);
                }
                list.add(lead);
                if (itr.hasNext()) {
                    lead = (IHasPosition)itr.next();
                    this.leadingEdge.set(i, lead);
                    continue;
                }
                this.leadingEdge.set(i, null);
                break;
            }
            ++i;
        }
    }

    protected boolean shouldContinue(IHasPosition lead, IHasPosition p, boolean capture) {
        if (lead == null) {
            return false;
        }
        if (p == null) {
            return true;
        }
        return capture ? PositionUtils.comparePositions(lead, p) <= 0 : PositionUtils.comparePositions(lead, p) < 0;
    }

    protected void advanceTo(IHasPosition p, boolean capture) {
        int i = 0;
        while (i < this.itrs.size()) {
            IHasPosition lead;
            Iterator<P> itr = this.itrs.get(i);
            List<P> nextList = this.next.get(i);
            List<P> unmatchedList = this.unmatched.get(i);
            Iterator<P> listItr = nextList.iterator();
            while (listItr.hasNext()) {
                lead = (IHasPosition)listItr.next();
                if (p != null && PositionUtils.comparePositions(lead, p) >= 0) continue;
                if (unmatchedList.size() == 0) {
                    unmatchedList = new ArrayList<P>();
                    this.unmatched.set(i, unmatchedList);
                }
                listItr.remove();
                unmatchedList.add(lead);
            }
            lead = (IHasPosition)this.leadingEdge.get(i);
            while (this.shouldContinue(lead, p, capture)) {
                if (nextList.size() == 0) {
                    nextList = new ArrayList<P>(1);
                    this.next.set(i, nextList);
                }
                nextList.add(lead);
                if (itr.hasNext()) {
                    lead = (IHasPosition)itr.next();
                    this.leadingEdge.set(i, lead);
                    continue;
                }
                this.leadingEdge.set(i, null);
                break;
            }
            ++i;
        }
    }

    protected boolean isNextUneven() {
        IHasPosition result = null;
        boolean allEmpty = true;
        boolean oneEmpty = false;
        for (List<P> list : this.next) {
            allEmpty &= list.isEmpty();
            oneEmpty |= list.isEmpty();
            for (IHasPosition p : list) {
                if (result == null) {
                    result = p;
                }
                if (PositionUtils.equalAsPositions(result, p)) continue;
                return true;
            }
        }
        if (allEmpty) {
            return false;
        }
        return oneEmpty;
    }

    protected boolean haveMore() {
        for (IHasPosition p : this.leadingEdge) {
            if (p == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isLeadEven() {
        IHasPosition result = null;
        for (IHasPosition p : this.leadingEdge) {
            if (p == null) {
                return false;
            }
            if (result == null) {
                result = p;
            }
            if (PositionUtils.equalAsPositions(result, p)) continue;
            return false;
        }
        return true;
    }

    protected void voidEmptyNext() {
        if (this.next == null) {
            return;
        }
        for (List<P> list : this.next) {
            if (list.isEmpty()) continue;
            return;
        }
        this.next = null;
        this.nextPos = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

