/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.property.Configuration;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigDescriptor
extends LinkedHashMap<String, IPropertyDescriptor>
implements IConfigDescriptor {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String desc;

    public ConfigDescriptor() {
    }

    public ConfigDescriptor(String id, String name, String desc) {
        if (id.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void setID(String id) {
        if (this.id != null) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    @Override
    public void setDescription(String desc) {
        if (this.desc != null) {
            throw new IllegalStateException();
        }
        if (desc == null) {
            desc = "";
        }
        this.desc = desc;
    }

    @Override
    public IConfiguration create(IConfiguration params) {
        IConfiguration result = this.createDefault();
        result.configure(params);
        return result;
    }

    @Override
    public IConfiguration createDefault() {
        return new Configuration(this);
    }

    @Override
    public boolean validate(IConfiguration config) {
        if (!config.getID().equals(this.getID())) {
            return false;
        }
        if (config.size() != this.size()) {
            return false;
        }
        for (IPropertyDescriptor desc : this.values()) {
            String value = (String)config.get(desc.getID());
            if (value == null) {
                return false;
            }
            if (desc.isValid(value)) continue;
            return false;
        }
        return true;
    }
}

