/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class RandomWalk {
    private Map model = new HashMap();
    private Map hiddenToSeen = new HashMap();
    private Map seenToHidden = new HashMap();
    private static final double LAMBDA = 0.01;

    public double score(Object hidden, Object seen) {
        return ((Counter)this.model.get(hidden)).getNormalizedCount(seen);
    }

    public double score(Object hidden, Object seen, int steps) {
        double total = 0.0;
        for (int i = 0; i <= steps; ++i) {
            total += Math.pow(0.01, steps) * this.step(hidden, seen, steps);
        }
        return total;
    }

    public double step(Object hidden, Object seen, int steps) {
        if (steps < 1) {
            return ((Counter)this.hiddenToSeen.get(hidden)).getNormalizedCount(seen);
        }
        double total = 0.0;
        for (Object seen1 : this.seenToHidden.keySet()) {
            for (Object hidden1 : this.hiddenToSeen.keySet()) {
                double subtotal = ((Counter)this.hiddenToSeen.get(hidden)).getNormalizedCount(seen1) * ((Counter)this.seenToHidden.get(seen1)).getNormalizedCount(hidden1);
                total += (subtotal += this.score(hidden1, seen, steps - 1));
            }
        }
        return total;
    }

    public void train(Collection data) {
        for (Pair p : data) {
            Object seen = p.first();
            Object hidden = p.second();
            if (!this.hiddenToSeen.keySet().contains(hidden)) {
                this.hiddenToSeen.put(hidden, new Counter());
            }
            ((Counter)this.hiddenToSeen.get(hidden)).incrementCount(seen);
            if (!this.seenToHidden.keySet().contains(seen)) {
                this.seenToHidden.put(seen, new Counter());
            }
            ((Counter)this.seenToHidden.get(seen)).incrementCount(hidden);
        }
    }

    public RandomWalk(Collection data, int steps) {
        HashMap m = new HashMap();
        this.train(data);
        for (Object seen : this.seenToHidden.keySet()) {
            if (!this.model.containsKey(seen)) {
                this.model.put(seen, new Counter());
            }
            for (Object hidden : this.hiddenToSeen.keySet()) {
                ((Counter)this.model.get(seen)).setCount(hidden, this.score(seen, hidden, steps));
            }
        }
    }
}

