/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.CollinsPuncTransformer;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformTreeDependency
implements Function<Tree, Tree> {
    TreeAnnotatorAndBinarizer binarizer;
    CollinsPuncTransformer collinsPuncTransformer;

    public TransformTreeDependency(TreebankLangParserParams tlpParams, boolean forceCNF) {
        this.binarizer = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, forceCNF, !Train.outsideFactor(), true) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), new LeftHeadFinder(), tlpParams, forceCNF, !Train.outsideFactor(), true);
        if (Train.collinsPunc) {
            this.collinsPuncTransformer = new CollinsPuncTransformer(tlpParams.treebankLanguagePack());
        }
    }

    @Override
    public Tree apply(Tree tree) {
        if (Train.hSelSplit) {
            this.binarizer.setDoSelectiveSplit(false);
            if (Train.collinsPunc) {
                tree = this.collinsPuncTransformer.transformTree(tree);
            }
            this.binarizer.transformTree(tree);
            this.binarizer.setDoSelectiveSplit(true);
        }
        if (Train.collinsPunc) {
            tree = this.collinsPuncTransformer.transformTree(tree);
        }
        tree = this.binarizer.transformTree(tree);
        return tree;
    }
}

