/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.DependencyTreeTransformer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationTransformer
implements TreeTransformer {
    boolean notDone = true;
    TreeTransformer tn = new DependencyTreeTransformer();

    @Override
    public Tree transformTree(Tree t) {
        this.tn.transformTree(t);
        Tree tt = this.UCPtransform(t);
        Tree ttt = this.CCtransform(tt);
        return ttt;
    }

    public Tree UCPtransform(Tree t) {
        Tree firstChild = t.firstChild();
        if (firstChild != null) {
            ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
            String patternMatch = "UCP=ucp <, /^JJ|ADJP/";
            String patternMatch2 = "UCP=ucp <, (DT $+ /^JJ|ADJP/)";
            String operation = "relabel ucp ADJP";
            TregexPattern matchPattern = null;
            TregexPattern matchPattern2 = null;
            try {
                matchPattern = TregexPattern.compile(patternMatch);
            }
            catch (Exception e) {
                System.err.println("Error compiling " + patternMatch);
            }
            try {
                matchPattern2 = TregexPattern.compile(patternMatch2);
            }
            catch (Exception e) {
                System.err.println("Error compiling " + patternMatch2);
            }
            TsurgeonPattern p = Tsurgeon.parseOperation(operation);
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern2, p));
            patternMatch = "UCP=ucp <, /^N/";
            patternMatch2 = "UCP=ucp <, (DT $+ /^N/)";
            operation = "relabel ucp NP";
            matchPattern = null;
            try {
                matchPattern = TregexPattern.compile(patternMatch);
            }
            catch (Exception e) {
                System.err.println("Error compiling match pattern");
            }
            try {
                matchPattern2 = TregexPattern.compile(patternMatch2);
            }
            catch (Exception e) {
                System.err.println("Error compiling " + patternMatch2);
            }
            p = Tsurgeon.parseOperation(operation);
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern2, p));
            Tree result = Tsurgeon.processPatternsOnTree(ops, t);
            return result;
        }
        return t;
    }

    public Tree CCtransform(Tree t) {
        this.notDone = true;
        Tree toReturn = new LabeledScoredTreeNode();
        while (this.notDone) {
            Tree cc = this.findCCparent(t, t);
            if (cc != null) {
                toReturn = cc;
                t = cc;
                continue;
            }
            this.notDone = false;
            toReturn = t;
        }
        return toReturn;
    }

    private String getHeadTag(Tree t) {
        if (t.value().startsWith("NN")) {
            return new String("NP");
        }
        if (t.value().startsWith("JJ")) {
            return new String("ADJP");
        }
        return new String("NP");
    }

    private Tree transformCC(Tree t, int ccIndex) {
        Tree[] ccSiblings = t.children();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = ccIndex + 1; i < ccSiblings.length; ++i) {
            if (!ccSiblings[i].value().startsWith("CC")) continue;
            list.add(new Integer(i));
        }
        if (!(ccIndex != 1 || ccSiblings[ccIndex - 1].value().equals("NP") || ccSiblings[ccIndex - 1].value().equals("ADJP") || ccSiblings[ccIndex - 1].value().equals("NNS"))) {
            int i;
            String leftHead = this.getHeadTag(ccSiblings[ccIndex - 1]);
            LabeledScoredTreeNode left = new LabeledScoredTreeNode(new StringLabel(leftHead), null);
            for (i = 0; i < ccIndex + 2; ++i) {
                left.addChild(ccSiblings[i]);
            }
            for (i = 0; i < ccIndex + 2; ++i) {
                t.removeChild(0);
            }
            if (!list.isEmpty()) {
                int index = (Integer)list.get(0);
                if (ccSiblings[index - 1].value().equals(",")) {
                    --index;
                }
                String head = this.getHeadTag(ccSiblings[index - 1]);
                LabeledScoredTreeNode tree = new LabeledScoredTreeNode(new StringLabel(head), null);
                tree.addChild(0, left);
                tree.addChild(1, ccSiblings[index - 1]);
                t.removeChild(0);
                t.addChild(0, tree);
            } else {
                t.addChild(0, left);
            }
        } else if (ccIndex == 2 && ccSiblings[0].value().startsWith("DT") && !ccSiblings[ccIndex - 1].value().equals("NNS") && (ccSiblings.length == 5 || !list.isEmpty() && (Integer)list.get(0) == 5)) {
            int i;
            String head = this.getHeadTag(ccSiblings[ccIndex - 1]);
            LabeledScoredTreeNode child = new LabeledScoredTreeNode(new StringLabel(head), null);
            for (i = 1; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            for (i = 1; i < ccIndex + 2; ++i) {
                t.removeChild(1);
            }
            t.addChild(1, child);
        } else if (ccIndex > 2 && ccSiblings[ccIndex - 2].value().equals(",") && !ccSiblings[ccIndex - 1].value().equals("NNS")) {
            int i;
            String head = this.getHeadTag(ccSiblings[ccIndex - 1]);
            LabeledScoredTreeNode child = new LabeledScoredTreeNode(new StringLabel(head), null);
            for (i = ccIndex - 3; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            for (i = ccIndex - 4; i > 0 && ccSiblings[i].value().equals(","); i -= 2) {
                child.addChild(0, ccSiblings[i]);
                child.addChild(0, ccSiblings[i - 1]);
            }
            if (i < 0) {
                i = -1;
            }
            for (int j = i + 1; j < ccIndex + 2; ++j) {
                t.removeChild(i + 1);
            }
            t.addChild(i + 1, child);
        } else {
            int i;
            boolean commaLeft = false;
            boolean commaRight = false;
            boolean preconj = false;
            int indexBegin = 0;
            LabeledScoredTreeNode conjT = new LabeledScoredTreeNode(new StringLabel("CC"), null);
            String leftHead = this.getHeadTag(ccSiblings[ccIndex - 1]);
            LabeledScoredTreeNode left = new LabeledScoredTreeNode(new StringLabel(leftHead), null);
            Tree first = ccSiblings[0];
            String leaf = first.children()[0].value().toLowerCase();
            if (leaf.equals("either") || leaf.equals("neither") || leaf.equals("both")) {
                preconj = true;
                indexBegin = 1;
                conjT.addChild(first.children()[0]);
            }
            for (int i2 = indexBegin; i2 < ccIndex - 1; ++i2) {
                left.addChild(ccSiblings[i2]);
            }
            if (ccSiblings[ccIndex - 1].value().equals(",")) {
                commaLeft = true;
            } else {
                left.addChild(ccSiblings[ccIndex - 1]);
            }
            Tree cc = ccSiblings[ccIndex];
            int nextCC = list.isEmpty() ? ccSiblings.length : (Integer)list.get(0);
            String rightHead = this.getHeadTag(ccSiblings[nextCC - 1]);
            LabeledScoredTreeNode right = new LabeledScoredTreeNode(new StringLabel(rightHead), null);
            for (i = ccIndex + 1; i < nextCC - 1; ++i) {
                right.addChild(ccSiblings[i]);
            }
            if (ccSiblings[nextCC - 1].value().equals(",")) {
                commaRight = true;
            } else {
                right.addChild(ccSiblings[nextCC - 1]);
            }
            for (i = 0; i < nextCC; ++i) {
                t.removeChild(0);
            }
            if (!list.isEmpty()) {
                LabeledScoredTreeNode tree = new LabeledScoredTreeNode(new StringLabel("NP"), null);
                if (preconj) {
                    tree.addChild(conjT);
                }
                tree.addChild(left);
                if (commaLeft) {
                    tree.addChild(ccSiblings[ccIndex - 1]);
                }
                tree.addChild(cc);
                tree.addChild(right);
                if (commaRight) {
                    t.addChild(0, ccSiblings[nextCC - 1]);
                }
                t.addChild(0, tree);
            } else {
                if (preconj) {
                    t.addChild(conjT);
                }
                t.addChild(left);
                if (commaLeft) {
                    t.addChild(ccSiblings[ccIndex - 1]);
                }
                t.addChild(cc);
                t.addChild(right);
                if (commaRight) {
                    t.addChild(ccSiblings[nextCC - 1]);
                }
            }
        }
        return t;
    }

    private boolean notNP(List<Tree> children, int ccIndex) {
        boolean toReturn = true;
        for (int i = ccIndex; i < children.size(); ++i) {
            if (!children.get(i).value().startsWith("NP")) continue;
            toReturn = false;
            break;
        }
        return toReturn;
    }

    private Tree findCCparent(Tree t, Tree root) {
        if (t.isPreTerminal()) {
            Tree parent;
            if (t.value().startsWith("CC") && (parent = t.parent(root)).value().startsWith("NP")) {
                List<Tree> children = parent.getChildrenAsList();
                int ccIndex = children.indexOf(t);
                if (children.size() > ccIndex + 2 && this.notNP(children, ccIndex) && ccIndex != 0) {
                    Tree newChild;
                    parent = newChild = this.transformCC(parent, ccIndex);
                    return root;
                }
            }
        } else {
            for (Tree child : t.getChildrenAsList()) {
                Tree cur = this.findCCparent(child, root);
                if (cur == null) continue;
                return cur;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        CoordinationTransformer transformer = new CoordinationTransformer();
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        if (treeFileName != null) {
            try {
                Tree t;
                PennTreeReader tr = new PennTreeReader((Reader)new BufferedReader(new InputStreamReader(new FileInputStream(treeFileName))), new LabeledScoredTreeFactory());
                while ((t = tr.readTree()) != null) {
                    ((AbstractCollection)tb).add(t);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("File problem: " + e);
            }
        }
        for (Tree t : tb) {
            System.out.println("Original tree");
            t.pennPrint();
            System.out.println();
            System.out.println("Tree transformed");
            Tree tree = transformer.transformTree(t);
            tree.pennPrint();
            System.out.println();
            System.out.println("----------------------------");
        }
    }
}

