/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Filter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammaticalStructureFactory {
    private final Constructor con;
    private final Filter<String> puncFilter;

    public GrammaticalStructureFactory(String name) {
        this(name, null);
    }

    public GrammaticalStructureFactory(String name, Filter<String> puncFilter) {
        Class<?> f;
        Class<?> t;
        Class<?> c;
        try {
            c = Class.forName(name);
            if (!Class.forName("edu.stanford.nlp.trees.GrammaticalStructure").isAssignableFrom(c)) {
                throw new ClassNotFoundException();
            }
            t = Class.forName("edu.stanford.nlp.trees.Tree");
            f = Class.forName("edu.stanford.nlp.util.Filter");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + name + " does not exist or does not extend edu.stanford.nlp.trees.GrammaticalStructure.");
        }
        try {
            this.con = puncFilter == null ? c.getConstructor(t) : c.getConstructor(t, f);
            this.puncFilter = puncFilter;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException();
        }
    }

    public GrammaticalStructure newGrammaticalStructure(Tree t) {
        try {
            if (this.puncFilter == null) {
                return (GrammaticalStructure)this.con.newInstance(t);
            }
            return (GrammaticalStructure)this.con.newInstance(t, this.puncFilter);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + this.con.getDeclaringClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.con.getDeclaringClass().getName() + "(Tree t) does not have public access");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

