/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class ArabicTreeNormalizer
extends BobChrisTreeNormalizer {
    private boolean retainNPTmp;
    private boolean markPRDverb;
    private boolean normalizeConj = false;
    private boolean changeNoLabels = false;
    private Pattern prdPattern = Pattern.compile("^[A-Z]+-PRD");
    private TregexPattern prdVerbPattern;
    private static final boolean escape = false;
    private static final Collection escapeCharacters = Arrays.asList("/", "*");
    private static final Pattern wrongConjPattern = Pattern.compile("NNP|NO_FUNC|NOFUNC");

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels) {
        super(new ArabicTreebankLanguagePack());
        this.retainNPTmp = retainNPTmp;
        this.markPRDverb = markPRDverb;
        this.changeNoLabels = changeNoLabels;
        try {
            this.prdVerbPattern = TregexPattern.compile("/^V[^P]/ > VP $ /-PRD$/=prd");
        }
        catch (ParseException e) {
            System.out.println(e);
            throw new RuntimeException();
        }
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb) {
        this(retainNPTmp, markPRDverb, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp) {
        this(retainNPTmp, false);
    }

    public ArabicTreeNormalizer() {
        this(false);
    }

    public String normalizeNonterminal(String category) {
        if (this.changeNoLabels) {
            return category;
        }
        if (this.retainNPTmp && category != null && category.equals("NP-TMP")) {
            return category;
        }
        if (this.markPRDverb && category != null && this.prdPattern.matcher(category).matches()) {
            return category;
        }
        return super.normalizeNonterminal(category);
    }

    public String normalizeTerminal(String leaf) {
        if (this.changeNoLabels) {
            return leaf;
        }
        return super.normalizeTerminal(leaf);
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        tree = super.normalizeWholeTree(tree, tf);
        for (Tree t : tree) {
            if (t.isPreTerminal()) {
                if (t.value().equals("PREP") && t.firstChild().value().equals("Ely")) {
                    System.err.println("ATBNormalizer ERROR: correcting Ely to ElY: " + t);
                    t.children()[0].label().setValue("ElY");
                } else if (t.label().value() == null || t.label().value().equals("")) {
                    System.err.println("ATBNormalizer ERROR: missing tag: " + t);
                }
            }
            if (t.isPreTerminal() || t.isLeaf()) continue;
            ArrayList<Tree> newKids = new ArrayList<Tree>(t.children().length);
            for (int j = 0; j < t.children().length; ++j) {
                Tree child = t.children()[j];
                if (child.isLeaf()) {
                    newKids.add(tf.newTreeNode("DUMMYTAG", Arrays.asList(child)));
                    continue;
                }
                newKids.add(child);
            }
            t.setChildren(newKids);
        }
        if (this.markPRDverb) {
            TregexMatcher m = this.prdVerbPattern.matcher(tree);
            Tree match = null;
            while (m.find()) {
                if (m.getMatch() == match) continue;
                match = m.getMatch();
                match.label().setValue(match.label().value() + "-PRDverb");
                Tree prd = m.getNode("prd");
                prd.label().setValue(super.normalizeNonterminal(prd.label().value()));
            }
        }
        if (this.normalizeConj && tree.isPreTerminal() && tree.children()[0].label().value().equals("w") && wrongConjPattern.matcher(tree.label().value()).matches()) {
            System.err.print("ATBNormalizer ERROR: bad CC remapped tree " + tree + " to ");
            tree.label().setValue("CC");
            System.err.println(tree);
        }
        if (tree.isPreTerminal()) {
            String val = tree.label().value();
            if (val.equals("CC") || val.equals("PUNC")) {
                System.err.println("ATBNormalizer ERROR: bare tagged word: " + tree + " being wrapped in FRAG");
                tree = tf.newTreeNode("FRAG", Collections.singletonList(tree));
            } else {
                System.err.println("ATBNormalizer ERROR: bare tagged word: " + tree + ": fix it!!");
            }
        }
        if (!tree.label().value().equals("ROOT")) {
            tree = tf.newTreeNode("ROOT", Collections.singletonList(tree));
        }
        return tree;
    }
}

