/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraLabel;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.util.Filter;
import java.util.Arrays;
import java.util.List;

public class NegraPennTreeNormalizer
extends TreeNormalizer {
    private static String root = "ROOT";
    private static String nonUnaryRoot = "NUR";
    protected final TreebankLanguagePack tlp;
    private boolean leaveGF = false;
    private boolean insertNPinPP = false;
    private static final String junkCPP = "---CJ";
    private static final String cpp = "CPP";
    private List prepositionTags = Arrays.asList("APPR", "APPRART");
    private List postpositionTags = Arrays.asList("APPO", "APZR");

    public String rootSymbol() {
        return root;
    }

    public String nonUnaryRootSymbol() {
        return nonUnaryRoot;
    }

    public void setLeaveGF(boolean b) {
        this.leaveGF = b;
    }

    public boolean getLeaveGF() {
        return this.leaveGF;
    }

    public void setInsertNPinPP(boolean b) {
        this.insertNPinPP = b;
    }

    public boolean getInsertNPinPP() {
        return this.insertNPinPP;
    }

    public NegraPennTreeNormalizer() {
        this(new NegraPennLanguagePack());
    }

    public NegraPennTreeNormalizer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    public String normalizeNonterminal(String category) {
        if (junkCPP.equals(category)) {
            category = cpp;
        }
        return this.cleanUpLabel(category).intern();
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        if (tree.label().value().equals(root) && tree.children().length > 1) {
            Tree underRoot = tree.treeFactory().newTreeNode(nonUnaryRoot, tree.getChildrenAsList());
            tree.setChildren(new Tree[1]);
            tree.children()[0] = underRoot;
        }
        if (this.insertNPinPP) {
            this.insertNPinPPall(tree);
        }
        if (!this.leaveGF) {
            for (Tree t : tree.subTrees()) {
                if (t.isLeaf() || t.label().value().matches("--.*")) continue;
                String[] catEdge = t.label().value().split("-");
                String label = catEdge.length > 0 ? catEdge[0] : "-";
                NegraLabel l = new NegraLabel(label);
                if (catEdge.length > 1) {
                    l.setEdge(catEdge[1]);
                }
                t.setLabel(l);
            }
        }
        return tree.prune(new Filter(){

            public boolean accept(Object obj) {
                Tree t = (Tree)obj;
                Tree[] kids = t.children();
                Label l = t.label();
                return l == null || l.value() == null || !l.value().matches("^\\*T.*$") || t.isLeaf() || kids.length != 1 || !kids[0].isLeaf();
            }
        }, tf).spliceOut(new Filter(){

            public boolean accept(Object obj) {
                Tree t = (Tree)obj;
                if (t.isLeaf() || t.isPreTerminal() || t.children().length != 1) {
                    return true;
                }
                return t.label() == null || !t.label().equals(t.children()[0].label());
            }
        }, tf);
    }

    private void insertNPinPPall(Tree t) {
        Tree[] kids = t.children();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            this.insertNPinPPall(kids[i]);
        }
        this.insertNPinPP(t);
    }

    private void insertNPinPP(Tree t) {
        if (this.tlp.basicCategory(t.label().value()).equals("PP")) {
            int i;
            Tree[] kids = t.children();
            int j = kids.length - 1;
            for (i = 0; i < j && this.prepositionTags.contains(this.tlp.basicCategory(kids[i].label().value())); ++i) {
            }
            while (i < j && this.postpositionTags.contains(this.tlp.basicCategory(kids[j].label().value()))) {
                --j;
            }
            if (i > j) {
                System.err.println("##### Warning -- no NP material here!");
                return;
            }
            int npKidsLength = j - i + 1;
            Tree[] npKids = new Tree[npKidsLength];
            System.arraycopy(kids, i, npKids, 0, npKidsLength);
            Tree np = t.treeFactory().newTreeNode(t.label().labelFactory().newLabel("NP"), Arrays.asList(npKids));
            Tree[] newPPkids = new Tree[kids.length - npKidsLength + 1];
            System.arraycopy(kids, 0, newPPkids, 0, i + 1);
            newPPkids[i] = np;
            System.arraycopy(kids, j + 1, newPPkids, i + 1, kids.length - j - 1);
            t.setChildren(newPPkids);
            System.out.println("#### inserted NP in PP");
            t.pennPrint();
        }
    }

    protected String cleanUpLabel(String label) {
        if (label == null) {
            label = root;
        }
        return label;
    }
}

