/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.TregexParser;
import edu.stanford.nlp.trees.tregex.TregexPattern;

public class TregexPatternCompiler {
    private Function basicCatFunction = new PennTreebankLanguagePack().getBasicCategoryFunction();
    private HeadFinder headFinder = new CollinsHeadFinder();
    public static TregexPatternCompiler defaultCompiler = new TregexPatternCompiler();

    public TregexPatternCompiler() {
    }

    public TregexPatternCompiler(Function basicCatFunction) {
        this.basicCatFunction = basicCatFunction;
    }

    public TregexPatternCompiler(HeadFinder headFinder) {
        this.headFinder = headFinder;
    }

    public TregexPatternCompiler(HeadFinder headFinder, Function basicCatFunction) {
        this.headFinder = headFinder;
        this.basicCatFunction = basicCatFunction;
    }

    public TregexPattern compile(String tregex) throws ParseException {
        TregexPattern.setBasicCatFunction(this.basicCatFunction);
        Relation.setHeadFinder(this.headFinder);
        TregexPattern pattern = TregexParser.parse(tregex);
        pattern.setPatternString(tregex);
        return pattern;
    }
}

