/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;

public class URLMetadataRepository
extends AbstractMetadataRepository {
    public static final String CONTENT_FILENAME = "content";
    public static final String XML_EXTENSION = ".xml";
    private static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    protected transient URL content;
    protected HashSet units = new LinkedHashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.URLMetadataRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    public static URL getActualLocation(URL base) {
        return URLMetadataRepository.getActualLocation(base, XML_EXTENSION);
    }

    public static URL getActualLocation(URL base, String extension) {
        String spec;
        if (extension == null) {
            extension = XML_EXTENSION;
        }
        if ((spec = base.toExternalForm()).endsWith(CONTENT_FILENAME + extension)) {
            try {
                return new URL(String.valueOf(spec) + extension);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        spec = spec.endsWith("/") ? String.valueOf(spec) + CONTENT_FILENAME : String.valueOf(spec) + "/content";
        try {
            return new URL(String.valueOf(spec) + extension);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URLMetadataRepository() {
    }

    public URLMetadataRepository(URL location, String name, Map properties) {
        super(name == null ? (location != null ? location.toExternalForm() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        this.content = URLMetadataRepository.getActualLocation(location);
    }

    protected synchronized URL getContentURL() {
        return this.content;
    }

    public synchronized void initialize(AbstractMetadataRepository.RepositoryState state) {
        this.name = state.Name;
        this.type = state.Type;
        this.version = state.Version.toString();
        this.provider = state.Provider;
        this.description = state.Description;
        this.location = state.Location;
        this.properties = state.Properties;
        this.units.addAll(Arrays.asList(state.Units));
    }

    public synchronized void initializeAfterLoad(URL repoLocation) {
        this.location = repoLocation;
        this.content = URLMetadataRepository.getActualLocation(this.location);
    }

    public boolean isModifiable() {
        return false;
    }

    public synchronized Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return query.perform(this.units.iterator(), collector);
    }
}

