/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards;

import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.wizards.page.ImportStoryPage;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.wizards.pages.SpecifySubjectPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewWSDSubjectFileWizard
extends Wizard
implements INewWizard {
    IWorkbench workbench;
    IStructuredSelection selection;
    SpecifySubjectPage specifySubjectPage;
    ImportStoryPage importStoryPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(WordnetUIMessages.WIZARD_NewSubjectFile_title);
        this.setDefaultPageImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/corpus_wiz.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.specifySubjectPage = new SpecifySubjectPage();
        this.importStoryPage = new ImportStoryPage();
        this.importStoryPage.setSelection((ISelection)this.selection);
        this.addPage((IWizardPage)this.specifySubjectPage);
        this.addPage((IWizardPage)this.importStoryPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.importStoryPage) {
            this.importStoryPage.setFilename(this.buildFilename());
        }
        return next;
    }

    protected String buildFilename() {
        StringBuilder fn = new StringBuilder();
        fn.append("wsd");
        fn.append("_s");
        String id = this.specifySubjectPage.getSubjectID();
        int i = 0;
        while (i < 3) {
            fn.append(id.charAt(i));
            ++i;
        }
        fn.append("_t");
        id = this.specifySubjectPage.getSubjectID();
        i = 0;
        while (i < 3) {
            fn.append(id.charAt(i));
            ++i;
        }
        fn.append("_???");
        fn.append(".sty");
        return fn.toString();
    }

    public boolean performFinish() {
        throw new UnsupportedOperationException();
    }
}

