/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.util.IWordInfo;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordnetUtils
implements IUtilityClass {
    private static final String leftParens = " (";
    private static final String rightParens = ")";
    private static final String comma = ", ";

    private WordnetUtils() {
    }

    public static Set<ISynset> extractSenses(IHasPosition p, IStoryData data) {
        LinkedHashSet<ISynset> result = new LinkedHashSet<ISynset>();
        if (data.supports(SenseRep.getInstance())) {
            IDescSet descs = data.getDescriptions(SenseRep.getInstance()).matchSet(p);
            for (IDesc desc : descs) {
                result.add((ISynset)desc.getData());
            }
        }
        return result;
    }

    public static String toString(ISynset synset) {
        if (synset == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(WordnetUtils.toWordString(synset));
        sb.append(leftParens);
        sb.append(((ISynsetID)synset.getID()).toString());
        sb.append(rightParens);
        return sb.toString();
    }

    public static String toWordString(ISynset synset) {
        if (synset == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        List words = synset.getWords();
        Iterator i = words.iterator();
        while (i.hasNext()) {
            sb.append(((IWord)i.next()).getLemma());
            if (!i.hasNext()) continue;
            sb.append(comma);
        }
        return sb.toString();
    }

    public static boolean matches(IDesc senseDesc) {
        ISense sense = (ISense)senseDesc.getData();
        return WordnetUtils.matches(sense.getPOSDesc(), senseDesc);
    }

    public static boolean matches(IDesc posDesc, IDesc senseDesc) {
        POS posPOS;
        IPosTag pos = (IPosTag)posDesc.getData();
        ISense sense = (ISense)senseDesc.getData();
        if (sense.getSense() == null) {
            return true;
        }
        POS sensePOS = sense.getSense().getPOS();
        return sensePOS == (posPOS = WordnetUtils.convertToPOS(pos.getTag()));
    }

    public static POS convertToPOS(ITag tag) {
        if (tag.isNoun() || tag.isProperNoun()) {
            return POS.NOUN;
        }
        if (tag.isVerb()) {
            return POS.VERB;
        }
        if (tag.isAdverb()) {
            return POS.ADVERB;
        }
        if (tag.isAdjective()) {
            return POS.ADJECTIVE;
        }
        return null;
    }

    public static PennTag convertToTag(POS pos) {
        if (pos == POS.NOUN) {
            return PennTag.NN;
        }
        if (pos == POS.VERB) {
            return PennTag.VB;
        }
        if (pos == POS.ADJECTIVE) {
            return PennTag.JJ;
        }
        if (pos == POS.ADVERB) {
            return PennTag.RB;
        }
        return null;
    }

    public static List<ISynset> getSynsets(String lemma, POS pos, IDictionary dict) {
        IIndexWord indexWord = dict.getIndexWord(lemma, pos);
        if (indexWord == null) {
            return Collections.emptyList();
        }
        ArrayList<ISynset> result = new ArrayList<ISynset>(indexWord.getWordIDs().size());
        for (IWordID wordID : indexWord.getWordIDs()) {
            ISynset synset = dict.getWord(wordID).getSynset();
            result.add(synset);
        }
        return result;
    }

    public static List<IWord> getWords(String lemma, POS pos, IDictionary dict) {
        IIndexWord indexWord = dict.getIndexWord(lemma, pos);
        if (indexWord == null) {
            return new ArrayList<IWord>();
        }
        ArrayList<IWord> result = new ArrayList<IWord>(indexWord.getWordIDs().size());
        for (IWordID wordID : indexWord.getWordIDs()) {
            result.add(dict.getWord(wordID));
        }
        return result;
    }

    public static List<IWord> getWords(IWordInfo info, IDictionary dict) {
        POS pos = WordnetUtils.convertToPOS(info.getPosTag().getTag());
        if (pos == null) {
            return new ArrayList<IWord>();
        }
        return WordnetUtils.getWords(info.getBaseForm(), pos, dict);
    }
}

