/* Filename: AddEntityChange.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 23, 2007
 */
package edu.mit.discourse.core.rep.referent.change;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import edu.mit.discourse.core.DiscourseMessages;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.IOrigin;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;


/** One line description goes here...
 * More detail goes here...
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 23, 2007)
 * @since 1.5.0
 */
public class RemoveReferenceChange extends AbstractModelChange {
	
	private final long entityID;
	private final long referenceID;
	private final ITiming timing;
	
	public RemoveReferenceChange(IReference reference, IDesc desc, ITiming timing) {
		super(DiscourseMessages.CHANGE_RemoveReference_name);
		
		if(!ReferentRep.getInstance().isType(desc)) throw new IllegalArgumentException();
		
		entityID = desc.getID();
		referenceID = reference.getID();
		this.timing = timing;
	}

	/* (non-Javadoc) @see edu.mit.story.core.provider.changes.AbstractSynchronizedProviderChange#synchronizedDoApply(java.lang.Object, edu.mit.story.core.provider.IDescriptionProvider) */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
		
		// get entity description
		IDesc oldDesc = provider.getData().getDescriptions(ReferentRep.getInstance()).getDescription(entityID);
		if(oldDesc == null) return null;
		
		// get the entity, check and see if it already has this segment
		IReferent oldData = (IReferent)oldDesc.getData();
		
		// construct the new reference map
		// if we can't find the reference to delete, don't do anything
		Map<Integer, Collection<? extends ISegment>> newRefs = new HashMap<Integer, Collection<? extends ISegment>>(oldData.getReferences().size());
		boolean found = false; 
		for(IReference oldRef : oldData.getReferences()){
			if(oldRef.getID() == referenceID){
				found = true;
				continue;
			}
			newRefs.put(oldRef.getID(), oldRef.getSegments());
		}
		if(!found) return null;

		IModelChange change = new RemoveDescriptionsChange(oldDesc);
		
		// add the new description
		IReferent newData = newRefs.isEmpty() ? null : new Referent(oldData.getName(), newRefs, null);
		if(newData != null){
			
			IDesc newDesc = new Desc(oldDesc.getID(), ReferentRep.getInstance(), newData.calculatePosition(), newData, oldDesc.getMetaData());
			newDesc.getMetaData().addDesc(new MetaDesc<IOrigin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
			if(timing != null)
				newDesc.getMetaData().addDesc(new MetaDesc<ITiming>(TimingMetaRep.getInstance(), newDesc, timing));
			change = new CompositeModelChange(change, new AddDescriptionsChange(newDesc));
		}

		// return the event
		return change.apply(source, provider);
	}

}
