/* Filename: IndicationTypeContentProvider.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 06/10/2009
 */
package nil.ucm.indications2.ui.content;

import nil.ucm.indications2.core.rep.IndicationType;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/** 
 *   Content provider for the types of indication structure to be shown in the IndicationCreationPage
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class IndicationTypeContentProvider implements IStructuredContentProvider {
	
	// the singleton instance
	private static IndicationTypeContentProvider instance = null;

	/**
	 * Returns the singleton instance of this class, instantiating if necessary.
	 */
	public static IndicationTypeContentProvider getInstance() {
		if (instance == null) instance = new IndicationTypeContentProvider();
		return instance;
	}
	
	/**
	 * This constructor is marked protected so that this class may be
	 * subclassed, but not directly instantiated.
	 */
	protected IndicationTypeContentProvider() {}

	/* 
	 * (non-Javadoc) @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	
	public Object[] getElements(Object inputElement) {
		return IndicationType.values();
	}

	/* 
	 * (non-Javadoc) @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	
	public void dispose() {	}

	/* 
	 * (non-Javadoc) @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {	}

}
