/* Filename: IndArgCaptureWidget.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 06/10/2009
 */
package nil.ucm.indications2.ui.widgets;

import nil.ucm.indications2.core.rep.IndicationType;
import nil.ucm.indications2.core.rep.model.IIndArgModel;
import nil.ucm.indications2.ui.content.IndicationTypeContentProvider;
import nil.ucm.indications2.ui.controllers.IIndArgController;
import nil.ucm.indications2.ui.label.IndicationTypeLabelProvider;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;

/** 
 *   Widget for the arguments of the reference in an indication structure.
 * It contains basically a combo viewer for selecting the type.
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class IndArgCaptureWidget<C extends IIndArgController> extends SegmentSetCaptureWidget<C> {

	// UI controls
	protected ComboViewer typeCombo;
	
	public IndArgCaptureWidget(Composite parent, int style, C controller) {
		super(parent, style, controller);
		controller.getArgModel().addChangeListener(this);
	}
	
	@Override
	protected void createTrailingControls(Composite parent) {
		
		// set layout for the parent
		GridLayout layout = new GridLayout(2, false);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.verticalSpacing = 0;
		parent.setLayout(layout);
		
		Label label;
		
		// label
		label = new Label(parent, SWT.NONE);
		label.setLayoutData(new GridData(SWT.TRAIL, SWT.CENTER, false, false));
		label.setBackground(parent.getBackground());
		label.setForeground(parent.getForeground());
		label.setText("Type");
		
		// type combo
		typeCombo = new ComboViewer(parent);
		typeCombo.setContentProvider(IndicationTypeContentProvider.getInstance());
		typeCombo.setLabelProvider(IndicationTypeLabelProvider.getInstance());
		typeCombo.setInput(IndicationType.class);
		typeCombo.setSelection(new StructuredSelection(IndicationType.UNKNOWN));
		typeCombo.getControl().setLayoutData(new GridData(SWT.FILL, SWT.NONE, true, false));
		typeCombo.getCombo().setVisibleItemCount(10);
		typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				controller.setIndicationType(event.getSelection());
			}
		});
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.widgets.SegmentCaptureWidget#updateFromModel()
	 */
	@Override
	protected void updateFromModel() {
		
		IIndArgModel model = controller.getArgModel();
		
//		IndicationType type = model.getIndicationType() == null ? null : model.getIndicationType();
		IndicationType type = model.getType() == null ? null : model.getType();
		ISelection typeSel = type == null ? new StructuredSelection(IndicationType.UNKNOWN) : new StructuredSelection(type);
		
		if(!typeCombo.getSelection().equals(typeSel)) typeCombo.setSelection(typeSel);
		
		if (model.getSegments().isEmpty()) typeCombo.getControl().setEnabled(false);
		else typeCombo.getControl().setEnabled(true);
		
		super.updateFromModel();
	}

}
