/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.archetype;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.semantics.core.rep.archetype.ArchetypalReferent;
import edu.mit.semantics.core.rep.archetype.Archetype;
import edu.mit.semantics.core.rep.archetype.IArchetypalReferent;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;

public class ArchetypeRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.archetype";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public ArchetypeRep() {
        super(IArchetypalReferent.class, v01);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)CorefRep.getInstance());
    }

    public String serialize(IData data) {
        IArchetypalReferent actor = (IArchetypalReferent)data;
        return this.serializeV01(actor);
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model) {
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        if (v01.equals((Object)version)) {
            return this.reconstituteV01(p, description, model);
        }
        return this.reconstitute(p, description, model, this.getVersion());
    }

    protected String serializeV01(IArchetypalReferent data) {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add(data.getArchetype().name());
        fields.add(Long.toString(data.getActor().getID()));
        return BlockMapper.PIPE.serialize(fields);
    }

    protected IArchetypalReferent reconstituteV01(IHasPosition p, String description, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(description);
        Archetype type = Archetype.valueOf((String)fields.get(0));
        long id = Long.parseLong((String)fields.get(1));
        IDesc actor = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(id);
        return new ArchetypalReferent(type, actor);
    }
}

