/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context.rules;

import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.context.problems.UnknownRoleProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoUnknownRolesRule
extends AbstractBuildRule {
    public static final String ID = NoUnknownRolesRule.class.getCanonicalName();

    public NoUnknownRolesRule() {
        super(ContextRelationRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        if (!model.supports(ContextRelationRep.getInstance())) {
            return null;
        }
        DescSet problems = new DescSet(ContextRelationRep.getInstance());
        for (IDesc d : model.getData().getDescriptions(ContextRelationRep.getInstance())) {
            IContextArg arg;
            IContextRelation rel = (IContextRelation)d.getData();
            Iterator<? extends IContextArg> iterator = rel.getArguments().iterator();
            if (!iterator.hasNext() || (arg = iterator.next()).getRole() != IContextRole.UNKNOWN) continue;
            problems.add(d);
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : problems) {
            result.add((Object)new UnknownRoleProblem(d, this.getID()));
        }
        return result;
    }
}

