/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.Event;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.GenerateEventTimexModelChange;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.event";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public EventRep() {
        super(IEvent.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
    }

    public String serialize(IData data) {
        IEvent event = (IEvent)data;
        ArrayList<String> fields = new ArrayList<String>(11);
        fields.add(event.getEventClass().name());
        fields.add(SegmentMapper.serializeStatic((Collection)event.getHeadTokens()));
        fields.add(SegmentMapper.serializeStatic((Collection)event.getEventTokens()));
        fields.add(event.getPOS().name());
        fields.add(event.getTense().name());
        fields.add(event.getAspect().name());
        fields.add(Boolean.toString(event.getPolarity()));
        fields.add(event.getPolarityTokens() == null ? "" : Segment.serialize((ISegment)event.getPolarityTokens()));
        fields.add(Integer.toString(event.getCardinality()));
        fields.add(event.getCardinalityTokens() == null ? "" : Segment.serialize((ISegment)event.getCardinalityTokens()));
        fields.add(event.getModalityTokens() == null ? "" : Segment.serialize((ISegment)event.getModalityTokens()));
        return BlockMapper.PIPE.serialize(fields);
    }

    public Event reconstitute(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(data);
        if (fields.size() == 9) {
            return this.legacyReconstitute(fields, model);
        }
        SegmentMapper mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
        EventClass eventClass = EventClass.valueOf((String)fields.get(0));
        SegmentSet headTokens = new SegmentSet((Collection)mapper.reconstitute((String)fields.get(1)));
        SegmentSet eventTokens = new SegmentSet((Collection)mapper.reconstitute((String)fields.get(2)));
        POS pos = POS.valueOf((String)fields.get(3));
        Tense tense = Tense.valueOf((String)fields.get(4));
        Aspect aspect = Aspect.valueOf((String)fields.get(5));
        boolean polarity = Boolean.parseBoolean((String)fields.get(6));
        ISegment polTokens = ((String)fields.get(7)).length() == 0 ? null : Segment.reconstitute((String)((String)fields.get(7)), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        int cardinality = Integer.parseInt((String)fields.get(8));
        ISegment cardTokens = ((String)fields.get(9)).length() == 0 ? null : Segment.reconstitute((String)((String)fields.get(9)), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        ISegment modeTokens = ((String)fields.get(10)).length() == 0 ? null : Segment.reconstitute((String)((String)fields.get(10)), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        return new Event(eventClass, (ISegmentSet)eventTokens, (ISegmentSet)headTokens, pos, tense, aspect, polarity, polTokens, cardinality, cardTokens, modeTokens);
    }

    protected Event legacyReconstitute(List<String> fields, IStoryModel model) {
        EventClass eventClass = EventClass.valueOf(fields.get(0));
        SegmentSet event = new SegmentSet(Collections.singleton(Segment.reconstitute((String)fields.get(1), (IRep)TokenRep.getInstance(), (IStoryData)model.getData())));
        POS pos = POS.valueOf(fields.get(2));
        Tense tense = Tense.valueOf(fields.get(3));
        Aspect aspect = Aspect.valueOf(fields.get(4));
        boolean polarity = Boolean.parseBoolean(fields.get(5));
        ISegment modality = fields.get(6).length() == 0 ? null : Segment.reconstitute((String)fields.get(6), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        int cardinality = Integer.parseInt(fields.get(7));
        ISegment cardTokens = fields.get(8).length() == 0 ? null : Segment.reconstitute((String)fields.get(8), (IRep)TokenRep.getInstance(), (IStoryData)model.getData());
        return new Event(eventClass, (ISegmentSet)event, (ISegmentSet)event, pos, tense, aspect, polarity, null, cardinality, cardTokens, modality);
    }

    public IModelChange getBatchModelChange() {
        return new GenerateEventTimexModelChange();
    }
}

