/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.rules;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.problems.ImproperTokensProblem;
import edu.mit.semantics.core.rep.event.problems.OverusedTokensProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.CollectionUtils;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTokenAccountingRule
extends AbstractBuildRule {
    public static final String ID = EventTokenAccountingRule.class.getCanonicalName();

    public EventTokenAccountingRule() {
        super(EventRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> hasOverused = new HashSet<IDesc>();
        HashSet<IDesc> hasImproper = new HashSet<IDesc>();
        IDescSet descs = model.getData().getDescriptions(EventRep.getInstance());
        Set allTokens = CollectionUtils.newSetFromMap(new IdentityHashMap());
        Set usedTokens = CollectionUtils.newSetFromMap(new IdentityHashMap());
        Set overusedTokens = CollectionUtils.newSetFromMap(new IdentityHashMap());
        Set improperTokens = CollectionUtils.newSetFromMap(new IdentityHashMap());
        LinkedList descList = new LinkedList();
        for (IDesc d : descs) {
            IEvent e = (IEvent)d.getData();
            allTokens.clear();
            allTokens.addAll(e.getEventTokens().getDescs());
            usedTokens.clear();
            overusedTokens.clear();
            improperTokens.clear();
            descList.clear();
            descList.addAll(e.getHeadTokens().getDescs());
            if (e.getCardinalityTokens() != null) {
                descList.addAll(e.getCardinalityTokens().getDescs());
            }
            if (e.getModalityTokens() != null) {
                descList.addAll(e.getModalityTokens().getDescs());
            }
            if (e.getPolarityTokens() != null) {
                descList.addAll(e.getPolarityTokens().getDescs());
            }
            for (IDesc token : descList) {
                if (allTokens.remove(token)) {
                    if (usedTokens.add(token)) continue;
                    overusedTokens.add(token);
                    continue;
                }
                if (usedTokens.add(token)) {
                    improperTokens.add(token);
                    continue;
                }
                overusedTokens.add(token);
            }
            if (!overusedTokens.isEmpty()) {
                hasOverused.add(d);
            }
            if (improperTokens.isEmpty()) continue;
            hasImproper.add(d);
        }
        Iterator i = hasOverused.iterator();
        while (i.hasNext()) {
            IDesc cd = (IDesc)i.next();
            IMetaDataSet checks = cd.getMetaData().get((IMetaRep)CheckMetaRep.getInstance());
            if (checks == null || !checks.contains((Object)new MetaDesc((IMetaRep)CheckMetaRep.getInstance(), cd, (IMetaData)new Check("edu.mit.semantics.event.problem.overusedTokens")))) continue;
            i.remove();
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            if (hasOverused.size() > 0) {
                result.add((Object)new OverusedTokensProblem(hasOverused, ID, "edu.mit.semantics.event.problem.overusedTokens"));
            }
            if (hasImproper.size() > 0) {
                result.add((Object)new ImproperTokensProblem(hasImproper, ID));
            }
        } else {
            for (IDesc d : hasOverused) {
                result.add((Object)new OverusedTokensProblem(d, ID, "edu.mit.semantics.event.problem.overusedTokens"));
            }
            for (IDesc d : hasImproper) {
                result.add((Object)new ImproperTokensProblem(d, ID));
            }
        }
        return result;
    }
}

