/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.model;

import edu.mit.jpropbank.ArgComparator;
import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.Tense;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.semantics.core.propbank.GenericRoleSet;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.ITreeNode;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.model.FeaturesModel;
import edu.mit.semantics.core.rep.semrole.model.IFeaturesModel;
import edu.mit.semantics.core.rep.semrole.model.ISemArgModel;
import edu.mit.semantics.core.rep.semrole.model.ISemRoleModel;
import edu.mit.semantics.core.rep.semrole.model.PredicateModel;
import edu.mit.semantics.core.rep.semrole.model.SemArgModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.notify.NotifyingSortedSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemRoleModel
extends PredicateModel
implements ChangeListener,
ISemRoleModel {
    public static final IMessageProvider noArguments = new Message("There must be at least one argument", 3);
    private final MessageProviderManager manager;
    private final SortedSet<ISemArgModel> arguments = new NotifyingSortedSet((Comparator)ArgComparator.getInstance(), (INotifyCollectionCallback)new INotifyCollectionCallback<ISemArgModel>(){

        public void elementAdded(ISemArgModel added) {
            SemRoleModel.this.manager.add((INotifyingMessageProvider)added);
            added.addChangeListener(SemRoleModel.this);
            SemRoleModel.this.fireChanged();
        }

        public void elementRemoved(ISemArgModel removed) {
            SemRoleModel.this.manager.remove((INotifyingMessageProvider)removed);
            removed.removeChangeListener(SemRoleModel.this);
            SemRoleModel.this.fireChanged();
        }
    });
    private int terminal = -1;
    private IDesc parse = null;
    private IDesc loaded = null;
    private IDesc sentence = null;
    private IRoleset roleset = GenericRoleSet.getInstance();
    private SortedSet<IRoleset> rolesets = new TreeSet<IRoleset>(new Comparator<IRoleset>(){

        @Override
        public int compare(IRoleset o1, IRoleset o2) {
            return o1.getID().compareTo(o2.getID());
        }
    });
    private SortedSet<IRoleset> extRolesets = Collections.unmodifiableSortedSet(this.rolesets);

    public SemRoleModel(IStoryModel model) {
        this(new FeaturesModel(), model);
        this.rolesets.add((IRoleset)GenericRoleSet.getInstance());
    }

    public SemRoleModel(IFeaturesModel featuresModel, IStoryModel storyModel) {
        super(featuresModel, storyModel);
        this.manager = new MessageProviderManager((ChangeListener)this);
    }

    @Override
    public IRoleset getRoleset() {
        return this.roleset;
    }

    public int getTerminal() {
        if (this.terminal < 0) {
            IDesc desc = this.getParse();
            ITree parse = desc == null ? null : (ITree)desc.getData();
            ITree leaf = parse == null ? null : (ITree)parse.getLeafMap().get(this.getDesc());
            this.terminal = leaf == null ? -1 : parse.getLeaves().indexOf(leaf);
        }
        return this.terminal;
    }

    public Aspect getAspect() {
        return this.getFeaturesModel().getAspect();
    }

    public Form getForm() {
        return this.getFeaturesModel().getForm();
    }

    public Tense getTense() {
        return this.getFeaturesModel().getTense();
    }

    public boolean isActive() {
        return this.getFeaturesModel().isActive();
    }

    public boolean isThirdPerson() {
        return this.getFeaturesModel().isThirdPerson();
    }

    public List<? extends ISemArgModel> getArguments() {
        return new ArrayList<ISemArgModel>(this.arguments);
    }

    @Override
    protected void internalClear() {
        this.arguments.clear();
        this.loaded = null;
        this.roleset = GenericRoleSet.getInstance();
        this.rolesets.clear();
        this.rolesets.add((IRoleset)GenericRoleSet.getInstance());
        this.sentence = null;
        super.internalClear();
    }

    @Override
    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (!this.arguments.isEmpty()) {
            return false;
        }
        if (this.roleset != GenericRoleSet.getInstance()) {
            return false;
        }
        return super.isCleared();
    }

    @Override
    protected IMessageProvider calculateMessage() {
        if (this.manager.getMessageType() > 0) {
            return this.manager.getFixedMessage();
        }
        if (this.arguments.isEmpty()) {
            return noArguments;
        }
        IDesc sent = this.getSentence();
        if (sent != null) {
            for (ISemArgModel arg : this.arguments) {
                if (arg.getSentence() == sent) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("The argument '");
                sb.append(arg.getDisplayText());
                sb.append("' has tokens from a different sentence than that of the verb");
                return new Message(sb.toString(), 3);
            }
        }
        IRoleset roleset = this.getRoleset();
        block1: for (ISemArgModel arg : this.arguments) {
            String label = arg.getLabel();
            if (!Character.isDigit(label.charAt(label.length() - 1))) continue;
            for (IRole role : roleset.getRoles()) {
                if (role.getLabel().toString().equals(label)) continue block1;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("The role '");
            sb.append(label);
            sb.append("' is not a listed role for the selected roleset");
            return new Message(sb.toString(), 2);
        }
        return super.calculateMessage();
    }

    protected void setOutOfSync() {
        this.terminal = -1;
        this.parse = null;
        super.setOutOfSync();
    }

    @Override
    public IDesc getParse() {
        if (this.parse == null) {
            IDesc token = this.getDesc();
            IDescSet parses = token == null ? null : this.getStoryModel().getData().getDescriptions(ParseRep.getInstance()).closedSet((IHasPosition)token);
            this.parse = parses == null || parses.size() != 1 ? null : (IDesc)parses.first();
        }
        return this.parse;
    }

    @Override
    public ITree getPredicate() {
        IDesc parse = this.getParse();
        int terminal = this.getTerminal();
        if (parse == null || terminal < 0) {
            return null;
        }
        ITree root = (ITree)parse.getData();
        return (ITree)root.getLeaves().get(terminal);
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDesc getLoaded() {
        return this.loaded;
    }

    @Override
    public void load(IDesc desc) {
        IDesc token;
        if (!SemRoleRep.getInstance().isType((IHasRep)desc)) {
            return;
        }
        this.clear();
        this.loaded = desc;
        ISemRole semRole = (ISemRole)desc.getData();
        IDescSet tokens = semRole.getPredicate().getTokens();
        IDesc iDesc = token = tokens.size() == 1 ? (IDesc)tokens.first() : null;
        if (token == null) {
            throw new IllegalArgumentException();
        }
        this.setDesc(token);
        this.getFeaturesModel().load((IPredicateFeatures)semRole);
        this.roleset = semRole.getRoleset();
        this.rolesets.add(this.roleset);
        for (IArg arg : semRole.getArguments()) {
            SemArgModel argModel = new SemArgModel(this.getStoryModel());
            argModel.load((IArg<? extends ITreeNode>)arg);
            argModel.setRoleset(this.roleset);
            this.arguments.add(argModel);
        }
        this.fireChanged();
    }

    @Override
    public SortedSet<IRoleset> getPossibleRoleSets() {
        return this.extRolesets;
    }

    @Override
    public void setPossibleRoleSets(Collection<? extends IRoleset> newRoleSets) {
        this.rolesets.clear();
        this.rolesets.add((IRoleset)GenericRoleSet.getInstance());
        if (newRoleSets != null) {
            this.rolesets.addAll(newRoleSets);
        }
        this.fireChanged();
    }

    @Override
    public void setRoleSet(IRoleset newRoleset) {
        if (this.roleset == newRoleset || newRoleset == null) {
            return;
        }
        this.roleset = newRoleset;
        for (ISemArgModel child : this.arguments) {
            child.setRoleset(newRoleset);
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public SortedSet<ISemArgModel> getArgumentModels() {
        return this.arguments;
    }

    public void setDesc(IDesc newDesc) {
        super.setDesc(newDesc);
        this.sentence = this.findSentence();
        this.fireChanged();
    }

    protected IDesc findSentence() {
        IDesc d = this.getDesc();
        if (d == null) {
            return null;
        }
        IDescSet sents = this.getStoryModel().getData().getDescriptions(SentenceRep.getInstance()).closedSet((IHasPosition)d);
        if (sents.size() != 1) {
            return null;
        }
        return (IDesc)sents.first();
    }

    @Override
    public IDesc getSentence() {
        return this.sentence;
    }
}

