/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.rules;

import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.problems.UnlistedRoleProblem;
import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllRolesListedRule
extends AbstractBuildRule {
    public AllRolesListedRule() {
        super(SemRoleRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        LinkedList<Aligner.Pair> unlisted = new LinkedList<Aligner.Pair>();
        for (IDesc semroleDesc : model.getData().getDescriptions(SemRoleRep.getInstance())) {
            ISemRole semrole = (ISemRole)semroleDesc.getData();
            if (semrole.getRoleset().getID().equals("lemma.XX") || CheckMetaRep.isChecked((IDesc)semroleDesc, (String)"edu.mit.semantics.core.problem.unlistedRole")) continue;
            IRoleset roleset = semrole.getRoleset();
            for (ISemArg arg : semrole.getArguments()) {
                if (!Character.isDigit(arg.getLabel().charAt(arg.getLabel().length() - 1)) || roleset.getRole(arg.getLabel(), arg.getFeature()) != null) continue;
                unlisted.add(new Aligner.Pair((Object)semroleDesc, (Object)arg.getLabel()));
            }
        }
        if (unlisted.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (Aligner.Pair pair : unlisted) {
            result.add((Object)new UnlistedRoleProblem((IDesc)pair.a, (String)pair.b, this.getID()));
        }
        return result;
    }
}

