/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.model;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.parsing.core.rep.token.TokenSegmentModel;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkType;
import edu.mit.semantics.core.rep.timelink.TimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.model.ITimeLinkModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

public class TimeLinkModel
extends AbstractViewModel
implements ITimeLinkModel,
IModelListener,
ChangeListener {
    public static final Message noRelTypeMsg = new Message("No relationship type has been specified", 3);
    private final IStoryModel storyModel;
    private final IDescModel sourceModel;
    private final IDescModel relatedModel;
    private final ISegmentModel signalModel;
    private IRelType relType = this.getDefaultRelType();
    private IDesc loaded = null;

    public TimeLinkModel(IStoryModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.storyModel = model;
        this.storyModel.addModelListener((IModelListener)this);
        this.relType = this.getDefaultRelType();
        this.sourceModel = new DescModel(model, this.relType.getType().getAppropriateReps());
        this.relatedModel = new DescModel(model, this.relType.getType().getAppropriateReps());
        this.signalModel = new TokenSegmentModel(model);
        this.sourceModel.addChangeListener((ChangeListener)this);
        this.relatedModel.addChangeListener((ChangeListener)this);
        this.signalModel.addChangeListener((ChangeListener)this);
    }

    public LinkType getLinkType() {
        return this.relType.getType();
    }

    public IRelType getRelationType() {
        return this.relType;
    }

    public IDesc getSource() {
        return this.sourceModel.getDesc();
    }

    public IDesc getRelated() {
        return this.relatedModel.getDesc();
    }

    public ISegment getSignal() {
        return this.signalModel.getSegment().isEmpty() ? null : this.signalModel.asSegment();
    }

    public IStoryModel getStoryModel() {
        return this.storyModel;
    }

    public IDescModel getSourceModel() {
        return this.sourceModel;
    }

    public IDescModel getRelatedModel() {
        return this.relatedModel;
    }

    public ISegmentModel getSignalModel() {
        return this.signalModel;
    }

    public void setLinkType(LinkType type) {
        this.setRelationType((IRelType)((Object)type.getUnspecifiedRelation()));
    }

    public void setRelationType(IRelType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (this.relType == type) {
            return;
        }
        this.relType = type;
        this.sourceModel.setReps(Arrays.asList(type.getType().getAppropriateReps()));
        this.relatedModel.setReps(Arrays.asList(type.getType().getAppropriateReps()));
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public void modelChanged(StoryChangeEvent e) {
    }

    public void setLoaded(IDesc desc) {
        if (!TimeLinkRep.getInstance().isType((IHasRep)desc)) {
            throw new IllegalArgumentException();
        }
        this.loaded = desc;
        ITimeLink link = (ITimeLink)desc.getData();
        this.relType = link.getRelationType();
        this.sourceModel.setDesc(link.getSource());
        this.relatedModel.setDesc(link.getRelated());
        this.signalModel.setSegment(link.getSignal() == null ? null : link.getSignal().getDescs());
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public IDesc getLoaded() {
        return this.loaded;
    }

    public void stateChanged(ChangeEvent e) {
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    protected void internalClear() {
        this.loaded = null;
        this.relType = this.getDefaultRelType();
        this.sourceModel.clear();
        this.relatedModel.clear();
        this.signalModel.clear();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (this.relType != this.getDefaultRelType()) {
            return false;
        }
        if (!this.sourceModel.isCleared()) {
            return false;
        }
        if (!this.relatedModel.isCleared()) {
            return false;
        }
        return this.signalModel.isCleared();
    }

    protected IRelType getDefaultRelType() {
        return (IRelType)((Object)LinkType.TEMPORAL.getUnspecifiedRelation());
    }

    protected IMessageProvider calculateMessage() {
        return this.relType.isUnspecified() ? noRelTypeMsg : Message.NO_MESSAGE;
    }

    public void dispose() {
        this.storyModel.removeModelListener((IModelListener)this);
        this.sourceModel.dispose();
        this.relatedModel.dispose();
        this.signalModel.dispose();
    }

    public ITimeLink toLink() {
        return new TimeLink(this.getRelationType(), this.getSource(), this.getRelated(), this.getSignal());
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public IHasPosition getDisplayPosition() {
        throw new UnsupportedOperationException();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }
}

