/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timex3.rules;

import edu.mit.parsing.core.rep.pos.GenericTag;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.semantics.core.rep.timex3.problems.UnusedLexicalTrigger;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckLexicalTriggers
extends AbstractBuildRule {
    public static final String ID = CheckLexicalTriggers.class.getCanonicalName();
    public static final Map<ITag, Set<String>> triggers;

    static {
        HashMap<GenericTag, Set<String>> result = new HashMap<GenericTag, Set<String>>();
        HashSet<String> forms = new HashSet<String>(Arrays.asList("millisecond", "second", "minute", "hour", "day", "month", "year", "decade", "century", "millenium", "dawn", "morning", "noon", "midday", "afternoon", "dusk", "evening", "night", "midnight", "winter", "spring", "summer", "fall", "solstice", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "today", "yesterday", "tomorrow", "now", "then", "past", "present", "future"));
        result.put(GenericTag.NOUN, Collections.unmodifiableSet(forms));
        forms = new HashSet<String>(Arrays.asList("past", "current", "future", "next", "previous", "hourly", "daily", "monthly", "yearly"));
        result.put(GenericTag.ADJECTIVE, Collections.unmodifiableSet(forms));
        forms = new HashSet<String>(Arrays.asList("previously", "currently", "lately", "next", "previous", "hourly", "daily", "monthly", "yearly"));
        result.put(GenericTag.ADJECTIVE, Collections.unmodifiableSet(forms));
        triggers = Collections.unmodifiableMap(result);
    }

    public CheckLexicalTriggers() {
        super(Timex3Rep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        UnusedLexicalTrigger p;
        if (!model.supports(Timex3Rep.getInstance())) {
            return null;
        }
        HashSet<IDesc> usedTokens = new HashSet<IDesc>();
        for (IDesc timexDesc : model.getData().getDescriptions(Timex3Rep.getInstance())) {
            ITimex3 timex = (ITimex3)timexDesc.getData();
            usedTokens.addAll((Collection<IDesc>)timex.getExpression().getDescs());
        }
        Set<IDesc> problems = null;
        problems = model.getData().supports(POSRep.getInstance()) ? this.findUnusedTriggersPOS(usedTokens, model) : this.findUnusedTriggersTokens(usedTokens, model);
        Iterator<IDesc> i = problems.iterator();
        while (i.hasNext()) {
            IMetaDataSet checks = i.next().getMetaData().get((IMetaRep)CheckMetaRep.getInstance());
            for (IMetaDesc check : checks) {
                if (!((ICheck)check.getData()).getCheck().equals("edu.mit.semantics.timex3.problem.unusedTrigger")) continue;
                i.remove();
            }
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            p = new UnusedLexicalTrigger(problems, this.getID());
            p.setCheck("edu.mit.semantics.timex3.problem.unusedTrigger");
            result.add((Object)p);
        } else {
            for (IDesc d : problems) {
                p = new UnusedLexicalTrigger(d, this.getID());
                p.setCheck("edu.mit.semantics.timex3.problem.unusedTrigger");
                result.add((Object)p);
            }
        }
        return result;
    }

    protected Set<IDesc> findUnusedTriggersPOS(Set<IDesc> usedTokens, IStoryModel model) {
        DescSet problems = new DescSet(TokenRep.getInstance());
        for (IDesc posDesc : model.getData().getDescriptions(POSRep.getInstance())) {
            IToken token;
            IPosTag tag = (IPosTag)posDesc.getData();
            if (!TokenRep.getInstance().isType((IHasRep)tag.getWord()) || !this.isTrigger(token = (IToken)tag.getWord().getData(), (ITag)tag.getTag().toGenericTag()) || usedTokens.contains(tag.getWord())) continue;
            problems.add(tag.getWord());
        }
        return problems;
    }

    protected Set<IDesc> findUnusedTriggersTokens(Set<IDesc> usedTokens, IStoryModel model) {
        DescSet problems = new DescSet(TokenRep.getInstance());
        for (IDesc tokenDesc : model.getData().getDescriptions(TokenRep.getInstance())) {
            IToken token = (IToken)tokenDesc.getData();
            if (!this.isTrigger(token, null) || usedTokens.contains(tokenDesc)) continue;
            problems.add(tokenDesc);
        }
        return problems;
    }

    protected boolean isTrigger(IToken token, ITag tag) {
        String form = token.getSurface().toLowerCase();
        if (tag != null) {
            Set<String> forms = triggers.get(tag);
            return forms == null ? false : forms.contains(form);
        }
        for (Set<String> forms : triggers.values()) {
            if (!forms.contains(form)) continue;
            return true;
        }
        return false;
    }
}

