/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.views;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.AdaptableMergeResult;
import com.collabnet.subversion.merge.AdaptableMergeResultsFolder;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.actions.DeleteMergeOutputAction;
import com.collabnet.subversion.merge.actions.MergeEditConflictsAction;
import com.collabnet.subversion.merge.actions.OpenFileInSystemEditorAction;
import com.collabnet.subversion.merge.views.MergeResultsViewContentProvider;
import com.collabnet.subversion.merge.views.MergeResultsViewLabelProvider;
import java.io.File;
import java.util.Iterator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.part.ViewPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.EditConflictsAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictVersion;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeResultsView
extends ViewPart {
    private static MergeResultsView view;
    private TreeViewer treeViewer;
    private MergeResultsViewLabelProvider labelProvider = new MergeResultsViewLabelProvider();
    private static ToggleLayoutAction[] toggleLayoutActions;
    private IAction toggleConflictsOnlyAction;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private RemoveAction removeAction = new RemoveAction();
    private RemoveAllAction removeAllAction = new RemoveAllAction();
    private SVNTreeConflict treeConflict;
    private OpenFileInSystemEditorAction openAction;
    public static final String ID = "com.collabnet.subversion.merge.views.MergeResultsView";
    public static final String LAYOUT_PREFERENCE = "MergeResultsView_layout";
    public static final String CONFLICTS_ONLY_PREFERENCE = "MergeResultsView_conflictsOnly";
    public static final int MODE_COMPRESSED_FOLDERS = 0;
    public static final int MODE_FLAT = 1;
    public static final int MODE_TREE = 2;

    public MergeResultsView() {
        view = this;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new MergeResultsViewContentProvider());
        this.treeViewer.setUseHashlookup(true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.treeViewer.setInput((Object)this);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MergeResultsView.this.treeConflict = null;
                IStructuredSelection selection = (IStructuredSelection)MergeResultsView.this.treeViewer.getSelection();
                Object selectedItem = selection.getFirstElement();
                MergeResult mergeResult = null;
                if (selectedItem instanceof AdaptableMergeResult) {
                    mergeResult = (MergeResult)selectedItem;
                }
                if (selectedItem instanceof AdaptableMergeResultsFolder) {
                    MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)selectedItem;
                    mergeResult = mergeResultsFolder.getMergeResult();
                }
                if (mergeResult != null) {
                    if (mergeResult.getResource() instanceof IFile && mergeResult.isConflicted() && !mergeResult.isResolved()) {
                        MergeResultsView.this.editConflicts(mergeResult);
                        return;
                    }
                    if (mergeResult.getResource() instanceof IFile && mergeResult.hasTreeConflict() && !mergeResult.isTreeConflictResolved()) {
                        boolean addAddConflict = false;
                        if (mergeResult.getResource() != null && mergeResult.getResource().exists()) {
                            MergeResultsView.this.treeConflict = MergeResultsView.this.getTreeConflict(mergeResult.getResource());
                            if (MergeResultsView.this.treeConflict != null && MergeResultsView.this.treeConflict.getDescription() != null && MergeResultsView.this.treeConflict.getDescription().contains("local add") && MergeResultsView.this.treeConflict.getDescription().contains("incoming add")) {
                                addAddConflict = true;
                            }
                            if (!addAddConflict) {
                                MergeResultsView.this.openAction.run();
                            }
                        }
                        if (!addAddConflict) {
                            return;
                        }
                    }
                    if (!mergeResult.getAction().equals("D")) {
                        final ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)mergeResult.getResource());
                        if (!localResource.exists()) {
                            return;
                        }
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                            public void run() {
                                block6: {
                                    try {
                                        if (MergeResultsView.this.treeConflict != null) {
                                            if (!localResource.isFolder()) {
                                                SVNConflictDescriptor descriptor = MergeResultsView.this.treeConflict.getConflictDescriptor();
                                                SVNConflictVersion rightVersion = descriptor.getSrcRightVersion();
                                                try {
                                                    RemoteFile remoteFile = new RemoteFile(localResource.getRepository(), new SVNUrl(String.valueOf(rightVersion.getReposURL()) + "/" + rightVersion.getPathInRepos()), (SVNRevision)new SVNRevision.Number(rightVersion.getPegRevision()));
                                                    SVNLocalCompareInput compareInput = new SVNLocalCompareInput(localResource, (ISVNRemoteResource)remoteFile);
                                                    CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)MergeResultsView.this.getSite().getPage());
                                                }
                                                catch (Exception exception) {}
                                            }
                                            return;
                                        }
                                        CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNLocalCompareInput(localResource, SVNRevision.BASE), (IWorkbenchPage)MergeResultsView.this.getSite().getPage());
                                    }
                                    catch (SVNException e) {
                                        if (e.operationInterrupted()) break block6;
                                        Activator.handleError(Messages.MergeResultsView_compareError, (Exception)((Object)e));
                                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MergeResultsView_compareWithLatest, (String)e.getLocalizedMessage());
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean mergeOutputSelected = false;
                IStructuredSelection selection = (IStructuredSelection)MergeResultsView.this.treeViewer.getSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof MergeOutput)) continue;
                    mergeOutputSelected = true;
                    break;
                }
                MergeResultsView.this.removeAction.setEnabled(mergeOutputSelected);
            }
        });
        this.createMenus();
        this.createToolbar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        if (Activator.getDefault().getPreferenceStore().getBoolean(CONFLICTS_ONLY_PREFERENCE)) {
            this.setContentDescription(Messages.MergeResultsView_conflictsMode);
        }
    }

    private void editConflicts(MergeResult mergeResult) {
        IFile resource = (IFile)mergeResult.getResource();
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            File conflictNewFile = svnResource.getStatus().getConflictNew();
            File conflictOldFile = svnResource.getStatus().getConflictOld();
            File conflictWorkingFile = svnResource.getStatus().getConflictWorking();
            File mergedFile = new File(resource.getLocation().toString());
            if (conflictWorkingFile == null) {
                EditConflictsAction editConflictsAction = new EditConflictsAction(resource);
                editConflictsAction.run(null);
            } else {
                MergeEditConflictsAction editConflictsAction = new MergeEditConflictsAction(conflictNewFile, conflictOldFile, conflictWorkingFile, mergedFile, resource.getName());
                editConflictsAction.setMergeResult(mergeResult);
                editConflictsAction.run(null);
            }
        }
        catch (Exception exception) {}
    }

    private void createMenus() {
        this.openAction = new OpenFileInSystemEditorAction(this.getSite().getPage(), (ISelectionProvider)this.treeViewer);
        MenuManager menuMgr = new MenuManager("#MergeResultsViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MergeResultsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        toggleLayoutActions = new ToggleLayoutAction[]{new ToggleLayoutAction(this, Messages.MergeResultsView_flat, "flatLayout.gif", 1), new ToggleLayoutAction(this, Messages.MergeResultsView_compressed, "compressedLayout.gif", 0)};
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        this.removeAction.setEnabled(false);
        actionBarsMenu.add((IAction)this.removeAction);
        actionBarsMenu.add((IAction)this.removeAllAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)toggleLayoutActions[0]);
        actionBarsMenu.add((IAction)toggleLayoutActions[1]);
        actionBarsMenu.add((IContributionItem)new Separator());
        this.toggleConflictsOnlyAction = new Action("Show conflicts only"){

            public void run() {
                MergeResultsView.this.store.setValue(MergeResultsView.CONFLICTS_ONLY_PREFERENCE, MergeResultsView.this.toggleConflictsOnlyAction.isChecked());
                if (MergeResultsView.this.toggleConflictsOnlyAction.isChecked()) {
                    MergeResultsView.this.setContentDescription(Messages.MergeResultsView_conflictsMode);
                } else {
                    MergeResultsView.this.setContentDescription("");
                }
                MergeResultsView.this.refresh();
            }
        };
        this.toggleConflictsOnlyAction.setChecked(this.store.getBoolean(CONFLICTS_ONLY_PREFERENCE));
        this.toggleConflictsOnlyAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("conflict.gif"));
        actionBarsMenu.add(this.toggleConflictsOnlyAction);
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(Messages.MergeResultsView_refresh, Activator.getDefault().getImageDescriptor("refresh.gif")){

            public void run() {
                MergeResultsView.this.refresh();
            }
        };
        refreshAction.setToolTipText(Messages.MergeResultsView_refreshView);
        toolbarManager.add((IAction)refreshAction);
        toolbarManager.add((IContributionItem)new Separator());
        PresentationAction presentationAction = new PresentationAction();
        toolbarManager.add((IAction)presentationAction);
        toolbarManager.add((IContributionItem)new Separator());
        Action collapseAllAction = new Action(Messages.MergeResultsView_collapseAll, Activator.getDefault().getImageDescriptor("collapseall.gif")){

            public void run() {
                MergeResultsView.this.collapseAll();
            }
        };
        collapseAllAction.setToolTipText(Messages.MergeResultsView_collapseAll);
        toolbarManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(Messages.MergeResultsView_expandAll, Activator.getDefault().getImageDescriptor("expandall.gif")){

            public void run() {
                MergeResultsView.this.expandAll();
            }
        };
        expandAllAction.setToolTipText(Messages.MergeResultsView_expandAll);
        toolbarManager.add((IAction)expandAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add(this.toggleConflictsOnlyAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        MergeResult mergeResult;
        boolean enableOpen = false;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        for (Object element : selection) {
            if (element instanceof AdaptableMergeResult && (mergeResult = (MergeResult)element).getResource() instanceof IFile && !mergeResult.isDelete()) {
                enableOpen = true;
            }
            if (enableOpen) break;
        }
        if (enableOpen) {
            manager.add((IAction)this.openAction);
        }
        if (enableOpen && selection.size() == 1) {
            MenuManager submenu = new MenuManager(Messages.MergeResultsView_openWith);
            mergeResult = (MergeResult)selection.getFirstElement();
            submenu.add((IContributionItem)new OpenWithMenu(this.getSite().getPage(), (IAdaptable)mergeResult.getResource()));
            manager.add((IContributionItem)submenu);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void collapseAll() {
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.collapseToLevel(this.treeViewer.getInput(), -1);
        this.treeViewer.getControl().setRedraw(true);
    }

    private void expandAll() {
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.expandAll();
        this.treeViewer.getControl().setRedraw(true);
    }

    public void setFocus() {
    }

    public void dispose() {
        view = null;
        super.dispose();
    }

    public static MergeResultsView getView() {
        return view;
    }

    public void refresh() {
        if (this.treeViewer == null || this.treeViewer.getControl().isDisposed()) {
            return;
        }
        this.removeAction.setEnabled(false);
        Object[] expandedElements = this.treeViewer.getVisibleExpandedElements();
        this.treeViewer.refresh();
        if (expandedElements != null && expandedElements.length > 0) {
            this.treeViewer.setExpandedElements(expandedElements);
        }
    }

    public void refreshAsync(final Object expandedObject) {
        if (this.treeViewer == null || this.treeViewer.getControl().isDisposed()) {
            return;
        }
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MergeOutput.setInProgress(true);
                MergeResultsView.this.refresh();
                if (expandedObject != null) {
                    MergeResultsView.this.treeViewer.setExpandedState(expandedObject, true);
                }
                MergeOutput.setInProgress(false);
            }
        });
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private SVNTreeConflict getTreeConflict(final IResource resource) {
        this.treeConflict = null;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNClientAdapter client = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().getSVNClient();
                    ISVNStatus[] statuses = client.getStatus(resource.getLocation().toFile(), true, true, true);
                    int i = 0;
                    while (i < statuses.length) {
                        if (statuses[i].hasTreeConflict()) {
                            MergeResultsView.this.treeConflict = new SVNTreeConflict(statuses[i]);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    SVNUIPlugin.log((int)4, (String)e.getMessage(), (Throwable)e);
                }
            }
        });
        return this.treeConflict;
    }

    static /* synthetic */ MergeResultsView access$0() {
        return view;
    }

    public static class PresentationAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public PresentationAction() {
            this.setText(Messages.MergeResultsView_presentation);
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("presentation.gif"));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            this.addActionToMenu(this.menu, toggleLayoutActions[0]);
            this.addActionToMenu(this.menu, toggleLayoutActions[1]);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    public static class RemoveAction
    extends Action {
        public RemoveAction() {
            this.setText(Messages.MergeResultsView_deleteSelected);
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("remove.gif"));
        }

        public void run() {
            DeleteMergeOutputAction deleteAction = new DeleteMergeOutputAction();
            deleteAction.selectionChanged((IAction)this, MergeResultsView.getView().getTreeViewer().getSelection());
            deleteAction.run((IAction)this);
        }
    }

    public static class RemoveAllAction
    extends Action {
        public RemoveAllAction() {
            this.setText(Messages.MergeResultsView_deleteAll);
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("remove_all.gif"));
        }

        public void run() {
            if (!MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MergeResultsView_deleteAll2, (String)Messages.MergeResultsView_confirmDelete)) {
                return;
            }
            TreeItem[] items = MergeResultsView.getView().getTreeViewer().getTree().getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() instanceof MergeOutput) {
                    MergeOutput mergeOutput = (MergeOutput)items[i].getData();
                    mergeOutput.delete();
                }
                ++i;
            }
            MergeResultsView.getView().refresh();
        }
    }

    public static class ToggleLayoutAction
    extends Action {
        private final int value;
        private MergeResultsView view;

        public ToggleLayoutAction(MergeResultsView view, String label, String icon, int value) {
            super(label, 8);
            this.view = view;
            this.value = value;
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor(icon));
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            this.setChecked(value == store.getInt(MergeResultsView.LAYOUT_PREFERENCE));
        }

        public int getValue() {
            return this.value;
        }

        public void run() {
            if (this.isChecked()) {
                Activator.getDefault().getPreferenceStore().setValue(MergeResultsView.LAYOUT_PREFERENCE, this.value);
                this.view.refresh();
            }
        }
    }
}

