/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardProjectsImportPage
extends WizardPage
implements IOverwriteQuery {
    public static final String METADATA_FOLDER = ".metadata";
    private ILeveledImportStructureProvider structureProvider;
    private static final String STORE_COPY_PROJECT_ID = "WizardProjectsImportPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    private Text directoryPathField;
    private CheckboxTreeViewer projectsList;
    private Button copyCheckbox;
    private boolean copyFiles = false;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Text archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private IProject[] wsProjects;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String lastPath;
    private long lastModified;

    public WizardProjectsImportPage() {
        this("wizardExternalProjectsPage");
    }

    public WizardProjectsImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsArea(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createOptionsArea(Composite workArea) {
        Composite optionsGroup = new Composite(workArea, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.copyCheckbox = new Button(optionsGroup, 32);
        this.copyCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.copyFiles = WizardProjectsImportPage.this.copyCheckbox.getSelection();
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WizardProjectsImportPage.this.getValidProjects();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectRecord)element).getProjectLabel();
            }
        });
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardProjectsImportPage.this.setPageComplete(WizardProjectsImportPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements((Object[])WizardProjectsImportPage.this.selectedProjects);
                WizardProjectsImportPage.this.setPageComplete(WizardProjectsImportPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements(new Object[0]);
                WizardProjectsImportPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
                } else {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(projectGroup, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.archiveRadioSelected();
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
            this.copyCheckbox.setSelection(true);
            this.copyCheckbox.setEnabled(false);
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            this.copyCheckbox.setEnabled(true);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList files = new ArrayList();
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isTarFile(path)) {
                        TarFile sourceTarFile = WizardProjectsImportPage.this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile == null) {
                            return;
                        }
                        WizardProjectsImportPage.this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                        Object child = WizardProjectsImportPage.this.structureProvider.getRoot();
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (!dirSelected && ArchiveFileManipulations.isZipFile(path)) {
                        ZipFile sourceFile = WizardProjectsImportPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            return;
                        }
                        WizardProjectsImportPage.this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                        Object child = WizardProjectsImportPage.this.structureProvider.getRoot();
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        if (!WizardProjectsImportPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.getValidProjects());
        if (this.getValidProjects().length < this.selectedProjects.length) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    private boolean collectProjectFilesFromDirectory(Collection files, File directory, Set directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection files, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(entry)));
        ArrayList children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            String elementLabel;
            Object child = childrenEnum.next();
            if (this.structureProvider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, child, level + 1, monitor);
            }
            if (!(elementLabel = this.structureProvider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell());
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        WizardProjectsImportPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        return true;
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        URI locationURI;
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            this.structureProvider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), this.structureProvider.getRoot(), this.structureProvider, this, fileSystemObjects);
            operation.setContext(this.getShell());
            operation.run(monitor);
            return true;
        }
        File importSource = null;
        if (this.copyFiles && (locationURI = record.description.getLocationURI()) != null) {
            importSource = new File(locationURI);
            IProjectDescription desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(record.description.getBuildSpec());
            desc.setComment(record.description.getComment());
            desc.setDynamicReferences(record.description.getDynamicReferences());
            desc.setNatureIds(record.description.getNatureIds());
            desc.setReferencedProjects(record.description.getReferencedProjects());
            record.description = desc;
        }
        try {
            try {
                monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        if (this.copyFiles && importSource != null) {
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren(importSource);
            ImportOperation operation = new ImportOperation(project.getFullPath(), importSource, FileSystemStructureProvider.INSTANCE, this, filesToImport);
            operation.setContext(this.getShell());
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            operation.run(monitor);
        }
        return true;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getValidProjects() {
        ArrayList<ProjectRecord> validProjects = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (!this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                validProjects.add(this.selectedProjects[i]);
            }
            ++i;
        }
        return validProjects.toArray(new ProjectRecord[validProjects.size()]);
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.copyFiles = settings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object file, Object parent, int level) {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectArchiveFile != null) {
                    InputStream stream = WizardProjectsImportPage.this.structureProvider.getContents(this.projectArchiveFile);
                    if (stream == null) {
                        if (this.projectArchiveFile instanceof ZipEntry) {
                            Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        } else if (this.projectArchiveFile instanceof TarEntry) {
                            Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        }
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(stream);
                        stream.close();
                        this.projectName = this.description.getName();
                    }
                }
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? WizardProjectsImportPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }
    }
}

