/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.QNMinimizer;

public class CGRunner {
    private final LambdaSolve prob;
    private final String filename;
    private final double tol;
    private final boolean useGaussianPrior;
    private double priorSigmaS = 0.5;
    private double[] sigmas = null;
    private static final double DEFAULT_TOLERANCE = 1.0E-4;
    private static final double DEFAULT_SIGMASQUARED = 0.5;

    public CGRunner(LambdaSolve prob, String filename) {
        this(prob, filename, 1.0E-4, true, 0.5);
    }

    public CGRunner(LambdaSolve prob, String filename, double tol, boolean useGaussianPrior, double priorSigmaS) {
        this.prob = prob;
        this.filename = filename;
        this.tol = tol;
        this.useGaussianPrior = useGaussianPrior;
        this.priorSigmaS = priorSigmaS;
    }

    public CGRunner(LambdaSolve prob, String filename, double tol, boolean useGaussianPrior, double[] sigmas) {
        this.prob = prob;
        this.filename = filename;
        this.tol = tol;
        this.useGaussianPrior = useGaussianPrior;
        this.sigmas = sigmas;
    }

    public void solve() {
        LikelihoodFunction df = new LikelihoodFunction(this.prob, this.tol, this.useGaussianPrior, this.priorSigmaS);
        if (this.sigmas != null) {
            df.setSigmas(this.sigmas);
        }
        MonitorFunction monitor = new MonitorFunction(this.prob, df, this.filename);
        QNMinimizer cgm = new QNMinimizer(monitor, 10);
        double[] result = cgm.minimize(df, this.tol, new double[df.domainDimension()]);
        this.prob.lambda = result;
        monitor.reportMonitoring(df.valueAt(result));
        System.err.println("after optimization value is " + df.valueAt(result));
    }

    private static final class LikelihoodFunction
    implements DiffFunction {
        private final LambdaSolve model;
        private final double tol;
        private final boolean useGaussianPrior;
        private final double sigmaSquared;
        private int valueAtCalls;
        private double likelihood;
        private double[] sigmas;

        public LikelihoodFunction(LambdaSolve m, double tol, boolean useGaussianPrior, double sigmaSquared) {
            this.model = m;
            this.tol = tol;
            this.useGaussianPrior = useGaussianPrior;
            this.sigmaSquared = sigmaSquared;
            this.sigmas = new double[this.model.lambda.length];
            int i = 0;
            while (i < this.sigmas.length) {
                this.sigmas[i] = sigmaSquared;
                ++i;
            }
        }

        public int domainDimension() {
            return this.model.lambda.length;
        }

        public double likelihood() {
            return this.likelihood;
        }

        public int numCalls() {
            return this.valueAtCalls;
        }

        public void setSigmas(double[] sigmas) {
            this.sigmas = sigmas;
        }

        public double valueAt(double[] lambda) {
            ++this.valueAtCalls;
            this.model.lambda = lambda;
            double lik = this.model.logLikelihoodScratch();
            if (this.useGaussianPrior) {
                int i = 0;
                while (i < lambda.length) {
                    lik += lambda[i] * lambda[i] / (this.sigmas[i] + this.sigmas[i]);
                    ++i;
                }
            }
            this.likelihood = lik;
            return lik;
        }

        public double[] derivativeAt(double[] lambda) {
            boolean eq = true;
            int j = 0;
            while (j < lambda.length) {
                if (Math.abs(lambda[j] - this.model.lambda[j]) > this.tol) {
                    eq = false;
                    break;
                }
                ++j;
            }
            if (!eq) {
                System.err.println("derivativeAt: call with different value");
                this.valueAt(lambda);
            }
            double[] drvs = this.model.getDerivatives();
            if (this.useGaussianPrior) {
                int j2 = 0;
                while (j2 < lambda.length) {
                    int n = j2;
                    drvs[n] = drvs[n] + lambda[j2] / this.sigmas[j2];
                    ++j2;
                }
            }
            return drvs;
        }
    }

    private static final class MonitorFunction
    implements Function {
        private final LambdaSolve model;
        private final LikelihoodFunction lf;
        private final String filename;
        private int iterations;

        public MonitorFunction(LambdaSolve m, LikelihoodFunction lf, String filename) {
            this.model = m;
            this.lf = lf;
            this.filename = filename;
        }

        public double valueAt(double[] lambda) {
            double likelihood = this.lf.likelihood();
            ++this.iterations;
            System.err.println(this.reportMonitoring(likelihood));
            if (this.iterations % 5 == 0) {
                if (this.iterations % 30 == 0) {
                    this.model.checkCorrectness();
                }
                this.model.save_lambdas(String.valueOf(this.filename) + "." + this.iterations + ".lam");
            }
            return 42.0;
        }

        public String reportMonitoring(double likelihood) {
            return "Iter. " + this.iterations + ": " + "neg. log cond. likelihood = " + likelihood + " [" + this.lf.numCalls() + " calls to valueAt]";
        }

        public int domainDimension() {
            return this.lf.domainDimension();
        }
    }
}

