/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.DiffFloatFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.FloatFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.Minimizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class QNMinimizer
implements Minimizer {
    private int k;
    private int M = 0;
    private boolean quiet = false;
    private Function monitor;
    private FloatFunction floatMonitor;
    private static NumberFormat nf = new DecimalFormat("0.000E0");
    private List<double[]> sList = new ArrayList<double[]>();
    private List<double[]> yList = new ArrayList<double[]>();
    private List<Double> roList = new ArrayList<Double>();
    private List<float[]> sList_float = new ArrayList<float[]>();
    private List<float[]> yList_float = new ArrayList<float[]>();
    private List<Float> roList_float = new ArrayList<Float>();

    public void shutUp() {
        this.quiet = true;
    }

    public void setM(int m) {
        this.M = m;
    }

    public QNMinimizer(int m) {
        this.M = m;
    }

    public QNMinimizer() {
    }

    public QNMinimizer(Function monitor) {
        this.monitor = monitor;
    }

    public QNMinimizer(Function monitor, int m) {
        this.monitor = monitor;
        this.M = m;
    }

    public QNMinimizer(FloatFunction monitor) {
        this.floatMonitor = monitor;
    }

    private static double[] plusAndConstMult(double[] a, double[] b, double c, double[] d) {
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i] + c * b[i];
        }
        return d;
    }

    private void computeDir(double[] dir, double[] fg) throws SurpriseConvergence {
        int i;
        System.arraycopy(fg, 0, dir, 0, fg.length);
        int mmm = this.sList.size();
        double[] as = new double[mmm];
        for (i = mmm - 1; i >= 0; --i) {
            as[i] = this.roList.get(i) * ArrayMath.innerProduct(this.sList.get(i), dir);
            QNMinimizer.plusAndConstMult(dir, this.yList.get(i), -as[i], dir);
        }
        if (mmm != 0) {
            double[] y = this.yList.get(mmm - 1);
            double yDotY = ArrayMath.innerProduct(y, y);
            if (yDotY == 0.0) {
                throw new SurpriseConvergence("Y is 0!!");
            }
            double gamma = ArrayMath.innerProduct(this.sList.get(mmm - 1), y) / yDotY;
            ArrayMath.multiplyInPlace(dir, gamma);
        }
        for (i = 0; i < mmm; ++i) {
            double b = this.roList.get(i) * ArrayMath.innerProduct(this.yList.get(i), dir);
            QNMinimizer.plusAndConstMult(dir, this.sList.get(i), as[i] - b, dir);
        }
        ArrayMath.multiplyInPlace(dir, -1.0);
    }

    public double[] minimize(Function function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    public double[] minimize(Function function, double functionTolerance, double[] initial, int maxIterations) {
        this.say("QNMinimizer called on double function of " + function.domainDimension() + " variables;");
        if (this.M > 0) {
            this.sayln(" Using m = " + this.M);
        } else {
            this.sayln(" Using dynamic setting of M.");
        }
        if (!(function instanceof DiffFunction)) {
            throw new UnsupportedOperationException();
        }
        DiffFunction dfunction = (DiffFunction)function;
        LinkedList<Double> previousVals = new LinkedList<Double>();
        double[] x = initial;
        double value = dfunction.valueAt(x);
        if (this.monitor != null) {
            this.monitor.valueAt(x);
        }
        double[] grad = new double[x.length];
        System.arraycopy(dfunction.derivativeAt(x), 0, grad, 0, grad.length);
        double[] newGrad = new double[x.length];
        double[] newX = new double[x.length];
        double[] dir = new double[x.length];
        this.sList = new ArrayList<double[]>();
        this.yList = new ArrayList<double[]>();
        this.roList = new ArrayList<Double>();
        this.sayln("Iter: n <chooseDir> [(derivInDir) chooseNewPoint] newValue (relAvgImprovement)\n");
        boolean have_max = maxIterations > 0;
        this.k = 0;
        while (true) {
            block14: {
                double[] nextY;
                double[] nextS;
                double newValue = 0.0;
                try {
                    this.say("Iter: " + this.k + " ");
                    this.say("<");
                    try {
                        this.computeDir(dir, grad);
                    }
                    catch (SurpriseConvergence s) {
                        this.clearStuff();
                        return x;
                    }
                    this.say("> ");
                    if (this.M > 0 && this.sList.size() == this.M || this.sList.size() == 20) {
                        nextS = this.sList.remove(0);
                        nextY = this.yList.remove(0);
                        this.roList.remove(0);
                    } else {
                        nextS = new double[x.length];
                        nextY = new double[x.length];
                    }
                    this.say("[");
                    newValue = this.lineSearch(dfunction, dir, x, newX, grad, value);
                    this.say("] ");
                }
                catch (OutOfMemoryError e) {
                    this.sayln(" --- Reached memory limit.  Setting m and redoing iteration...");
                    this.M = this.sList.size();
                    --this.k;
                    break block14;
                }
                System.arraycopy(dfunction.derivativeAt(newX), 0, newGrad, 0, newGrad.length);
                this.say(nf.format(newValue));
                QNMinimizer.plusAndConstMult(newX, x, -1.0, nextS);
                QNMinimizer.plusAndConstMult(newGrad, grad, -1.0, nextY);
                double ro = 1.0 / ArrayMath.innerProduct(nextS, nextY);
                this.sList.add(nextS);
                this.yList.add(nextY);
                this.roList.add(ro);
                previousVals.add(value);
                int size = previousVals.size();
                double previousVal = size == 10 ? (Double)previousVals.remove() : (Double)previousVals.peek();
                double averageImprovement = (previousVal - newValue) / (double)size;
                this.sayln(" (" + nf.format(averageImprovement / newValue) + ")");
                if (size > 5 && averageImprovement / newValue < functionTolerance || have_max && this.k >= maxIterations) {
                    this.clearStuff();
                    return newX;
                }
                if (this.monitor != null) {
                    this.monitor.valueAt(newX);
                }
                value = newValue;
                double[] temp = x;
                x = newX;
                newX = temp;
                System.arraycopy(newGrad, 0, grad, 0, newGrad.length);
                if (this.quiet) {
                    System.err.print(".");
                }
            }
            ++this.k;
        }
    }

    private double lineSearch(Function func, double[] dir, double[] x, double[] newX, double[] grad, double lastValue) {
        double newValue;
        double c1;
        double a;
        double normGradInDir = ArrayMath.innerProduct(dir, grad);
        this.say("(" + nf.format(normGradInDir) + ")");
        if (normGradInDir > 0.0) {
            this.say("{WARNING--- direction of positive gradient chosen!}");
        }
        if (this.k <= 2) {
            a = 0.1;
            c1 = 0.1;
        } else {
            a = 1.0;
            c1 = 0.1;
        }
        double c = 0.01;
        c *= normGradInDir;
        while (true) {
            double d;
            newValue = func.valueAt(QNMinimizer.plusAndConstMult(x, dir, a, newX));
            if (!(d > lastValue + c * a)) break;
            if (newValue < lastValue) {
                this.say("!");
            } else {
                this.say(".");
            }
            a = c1 * a;
        }
        return newValue;
    }

    private static float[] plusAndConstMult(float[] a, float[] b, float c, float[] d) {
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i] + c * b[i];
        }
        return d;
    }

    private void computeDir(float[] dir, float[] fg) throws SurpriseConvergence {
        int i;
        System.arraycopy(fg, 0, dir, 0, fg.length);
        int mmm = this.sList_float.size();
        float[] as = new float[mmm];
        for (i = mmm - 1; i >= 0; --i) {
            as[i] = this.roList_float.get(i).floatValue() * (float)ArrayMath.innerProduct(this.sList_float.get(i), dir);
            QNMinimizer.plusAndConstMult(dir, this.yList_float.get(i), -as[i], dir);
        }
        if (mmm != 0) {
            float[] y = this.yList_float.get(mmm - 1);
            float yDotY = (float)ArrayMath.innerProduct(y, y);
            if (yDotY == 0.0f) {
                throw new SurpriseConvergence("Y is 0!!");
            }
            float gamma = (float)ArrayMath.innerProduct(this.sList_float.get(mmm - 1), y) / yDotY;
            ArrayMath.multiplyInPlace(dir, (double)gamma);
        }
        for (i = 0; i < mmm; ++i) {
            float b = this.roList_float.get(i).floatValue() * (float)ArrayMath.innerProduct(this.yList_float.get(i), dir);
            QNMinimizer.plusAndConstMult(dir, this.sList_float.get(i), as[i] - b, dir);
        }
        ArrayMath.multiplyInPlace(dir, -1.0);
    }

    public float[] minimize(FloatFunction function, float functionTolerance, float[] initial) {
        this.say("QNMinimizer called on float function of " + function.domainDimension() + " variables;");
        if (this.M > 0) {
            this.sayln(" Using m = " + this.M);
        } else {
            this.sayln(" Using dynamic setting of M.");
        }
        if (!(function instanceof DiffFloatFunction)) {
            throw new UnsupportedOperationException();
        }
        DiffFloatFunction dfunction = (DiffFloatFunction)function;
        LinkedList<Float> previousVals = new LinkedList<Float>();
        float[] x = initial;
        float value = dfunction.valueAt(x);
        if (this.monitor != null) {
            this.floatMonitor.valueAt(x);
        }
        float[] grad = new float[x.length];
        System.arraycopy(dfunction.derivativeAt(x), 0, grad, 0, grad.length);
        float[] newGrad = new float[x.length];
        float[] newX = new float[x.length];
        float[] dir = new float[x.length];
        this.sList_float = new ArrayList<float[]>();
        this.yList_float = new ArrayList<float[]>();
        this.roList_float = new ArrayList<Float>();
        this.sayln("Iter: n <chooseDir> [(derivInDir) chooseNewPoint] newValue (relAvgImprovement)\n");
        this.k = 0;
        while (true) {
            block14: {
                float[] nextY;
                float[] nextS;
                float newValue = 0.0f;
                try {
                    this.say("Iter: " + this.k + " ");
                    this.say("<");
                    try {
                        this.computeDir(dir, grad);
                    }
                    catch (SurpriseConvergence s) {
                        this.clearStuff();
                        return x;
                    }
                    this.say("> ");
                    if (this.M > 0 && this.sList_float.size() == this.M || this.sList_float.size() == 20) {
                        nextS = this.sList_float.remove(0);
                        nextY = this.yList_float.remove(0);
                        this.roList_float.remove(0);
                    } else {
                        nextS = new float[x.length];
                        nextY = new float[x.length];
                    }
                    this.say("[");
                    newValue = this.lineSearch(dfunction, dir, x, newX, grad, value);
                    this.say("] ");
                }
                catch (OutOfMemoryError e) {
                    this.sayln(" --- Reached memory limit.  Setting m and redoing iteration...");
                    this.M = this.sList_float.size();
                    --this.k;
                    break block14;
                }
                System.arraycopy(dfunction.derivativeAt(newX), 0, newGrad, 0, newGrad.length);
                this.say(nf.format(newValue));
                QNMinimizer.plusAndConstMult(newX, x, -1.0f, nextS);
                QNMinimizer.plusAndConstMult(newGrad, grad, -1.0f, nextY);
                float ro = (float)(1.0 / ArrayMath.innerProduct(nextS, nextY));
                this.sList_float.add(nextS);
                this.yList_float.add(nextY);
                this.roList_float.add(Float.valueOf(ro));
                previousVals.add(Float.valueOf(value));
                int size = previousVals.size();
                float previousVal = (size == 10 ? (Float)previousVals.remove() : (Float)previousVals.peek()).floatValue();
                float averageImprovement = (previousVal - newValue) / (float)size;
                this.sayln(" (" + nf.format(averageImprovement / newValue) + ")");
                if (size > 5 && averageImprovement / newValue < functionTolerance) {
                    this.clearStuff();
                    return newX;
                }
                if (this.monitor != null) {
                    this.floatMonitor.valueAt(newX);
                }
                value = newValue;
                float[] temp = x;
                x = newX;
                newX = temp;
                System.arraycopy(newGrad, 0, grad, 0, newGrad.length);
                if (this.quiet) {
                    System.err.print(".");
                }
            }
            ++this.k;
        }
    }

    private float lineSearch(FloatFunction func, float[] dir, float[] x, float[] newX, float[] grad, float lastValue) {
        float newValue;
        float c1;
        float a;
        float normGradInDir = (float)ArrayMath.innerProduct(dir, grad);
        this.say("(" + nf.format(normGradInDir) + ")");
        if (normGradInDir > 0.0f) {
            this.say("{WARNING--- direction of positive gradient chosen!}");
        }
        if (this.k <= 2) {
            a = 0.1f;
            c1 = 0.1f;
        } else {
            a = 1.0f;
            c1 = 0.5f;
        }
        float c = 0.01f;
        c *= normGradInDir;
        while (true) {
            float f;
            newValue = func.valueAt(QNMinimizer.plusAndConstMult(x, dir, a, newX));
            if (!(f > lastValue + c * a)) break;
            if (newValue < lastValue) {
                this.say("!");
            } else {
                this.say(".");
            }
            a = c1 * a;
        }
        return newValue;
    }

    private void clearStuff() {
        this.sList = null;
        this.yList = null;
        this.roList = null;
        this.sList_float = null;
        this.yList_float = null;
        this.roList_float = null;
    }

    private void sayln(String s) {
        if (!this.quiet) {
            System.err.println(s);
        }
    }

    private void say(String s) {
        if (!this.quiet) {
            System.err.print(s);
        }
    }

    public static void main(String[] args) {
        int dim = 500000;
        double maxVar = 5.0;
        final double[] var = new double[500000];
        final float[] varF = new float[500000];
        double[] init = new double[500000];
        for (int i = 0; i < 500000; ++i) {
            init[i] = (double)(i + 1) / 500000.0 - 0.5;
            var[i] = 5.0 * (double)(i + 1) / 500000.0;
            varF[i] = (float)var[i];
        }
        float[] initF = ArrayMath.doubleArrayToFloatArray(init);
        final double[] grads = new double[500000];
        final float[] gradsF = new float[500000];
        DiffFunction f = new DiffFunction(){

            public double[] derivativeAt(double[] x) {
                double val = Math.PI * this.valuePow(x, 2.141592653589793);
                for (int i = 0; i < 500000; ++i) {
                    grads[i] = x[i] * var[i] * val;
                }
                return grads;
            }

            public double valueAt(double[] x) {
                return 1.0 + this.valuePow(x, Math.PI);
            }

            private double valuePow(double[] x, double pow) {
                double val = 0.0;
                for (int i = 0; i < 500000; ++i) {
                    val += x[i] * x[i] * var[i];
                }
                return Math.pow(val * 0.5, pow);
            }

            public int domainDimension() {
                return 500000;
            }
        };
        DiffFloatFunction fF = new DiffFloatFunction(){

            public float[] derivativeAt(float[] x) {
                float val = (float)Math.PI * this.valuePow(x, 2.141592653589793);
                for (int i = 0; i < 500000; ++i) {
                    gradsF[i] = x[i] * varF[i] * val;
                }
                return gradsF;
            }

            public float valueAt(float[] x) {
                return 1.0f + this.valuePow(x, Math.PI);
            }

            private float valuePow(float[] x, double pow) {
                float val = 0.0f;
                for (int i = 0; i < 500000; ++i) {
                    val += x[i] * x[i] * varF[i];
                }
                return (float)Math.pow((double)val * 0.5, pow);
            }

            public int domainDimension() {
                return 500000;
            }
        };
        QNMinimizer min = new QNMinimizer();
        System.out.println("-------------------------");
        System.out.println("-----               -----");
        System.out.println("-----    DOUBLE     -----");
        System.out.println("-----               -----");
        System.out.println("-------------------------");
        System.out.println();
        min.minimize(f, 1.0E-4, init);
        System.out.println("-------------------------");
        System.out.println("-----               -----");
        System.out.println("-----     FLOAT     -----");
        System.out.println("-----               -----");
        System.out.println("-------------------------");
        System.out.println();
        min.setM(0);
        min.minimize(fF, 1.0E-4f, initF);
    }

    private static class SurpriseConvergence
    extends Throwable {
        public SurpriseConvergence(String s) {
            super(s);
        }
    }
}

